/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.fluid;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;
import phanastrae.operation_starcleave.fluid.OperationStarcleaveFluids;
import phanastrae.operation_starcleave.item.OperationStarcleaveItems;
import phanastrae.operation_starcleave.registry.OperationStarcleaveFluidTags;

public abstract class PetrichoricPlasmaFluid
extends FlowingFluid {
    public Fluid getFlowing() {
        return OperationStarcleaveFluids.FLOWING_PETRICHORIC_PLASMA;
    }

    public Fluid getSource() {
        return OperationStarcleaveFluids.PETRICHORIC_PLASMA;
    }

    public Item getBucket() {
        return OperationStarcleaveItems.PETRICHORIC_PLASMA_BUCKET;
    }

    protected void animateTick(Level level, BlockPos pos, FluidState state, RandomSource random) {
        if (level.getBlockState(pos).isAir() && !level.getBlockState(pos).isSolidRender((BlockGetter)level, pos) && random.nextInt(200) == 0) {
            level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LAVA_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
    }

    protected boolean isRandomlyTicking() {
        return false;
    }

    @Nullable
    protected ParticleOptions getDripParticle() {
        return null;
    }

    protected void beforeDestroyingBlock(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity blockentity = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)state, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)blockentity);
    }

    public int getSlopeFindDistance(LevelReader level) {
        return 5;
    }

    public BlockState createLegacyBlock(FluidState state) {
        return (BlockState)OperationStarcleaveBlocks.PETRICHORIC_PLASMA.defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(PetrichoricPlasmaFluid.getLegacyLevel((FluidState)state)));
    }

    public boolean isSame(Fluid fluid) {
        return fluid == OperationStarcleaveFluids.PETRICHORIC_PLASMA || fluid == OperationStarcleaveFluids.FLOWING_PETRICHORIC_PLASMA;
    }

    public int getDropOff(LevelReader level) {
        return 1;
    }

    public boolean canBeReplacedWith(FluidState fluidState, BlockGetter blockReader, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !fluid.is(OperationStarcleaveFluidTags.PETRICHORIC_PLASMA);
    }

    public int getTickDelay(LevelReader level) {
        return 4;
    }

    protected boolean canConvertToSource(Level level) {
        return false;
    }

    protected void spreadTo(LevelAccessor level, BlockPos pos, BlockState blockState, Direction direction, FluidState fluidState) {
        if (direction == Direction.DOWN) {
            FluidState fluidstate = level.getFluidState(pos);
            if (this.is(OperationStarcleaveFluidTags.PETRICHORIC_PLASMA) && !fluidstate.isEmpty() && !fluidstate.is(OperationStarcleaveFluidTags.PETRICHORIC_PLASMA)) {
                if (blockState.getBlock() instanceof LiquidBlock) {
                    level.setBlock(pos, OperationStarcleaveBlocks.COAGULATED_PLASMA.defaultBlockState(), 3);
                }
                this.fizz(level, pos);
                return;
            }
        }
        super.spreadTo(level, pos, blockState, direction, fluidState);
    }

    private void fizz(LevelAccessor level, BlockPos pos) {
        level.levelEvent(1501, pos, 0);
    }

    protected float getExplosionResistance() {
        return 100.0f;
    }

    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.BUCKET_FILL);
    }

    public static class Source
    extends PetrichoricPlasmaFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends PetrichoricPlasmaFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }
}

