/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.item;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import phanastrae.operation_starcleave.entity.projectile.FirmamentRejuvenatorEntity;

public class FirmamentRejuvenatorItem
extends Item
implements ProjectileItem {
    public FirmamentRejuvenatorItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (!user.getAbilities().mayBuild) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        block8: {
            block7: {
                Player player;
                int i = this.getUseDuration(stack, user) - remainingUseTicks;
                if (i < 4) {
                    return;
                }
                world.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.PLAYERS, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
                if (!world.isClientSide) {
                    FirmamentRejuvenatorEntity entity = new FirmamentRejuvenatorEntity(world, user);
                    float speed = Math.min(6.66f, (float)i / 8.0f);
                    entity.shootFromRotation((Entity)user, user.getXRot(), user.getYRot(), -20.0f, speed, 1.0f);
                    world.addFreshEntity((Entity)entity);
                    if (user instanceof Player) {
                        Player player2 = (Player)user;
                        player2.getCooldowns().addCooldown((Item)this, 15);
                    }
                }
                if (user instanceof Player) {
                    player = (Player)user;
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                }
                if (!(user instanceof Player)) break block7;
                player = (Player)user;
                if (player.getAbilities().instabuild) break block8;
            }
            stack.shrink(1);
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    public Projectile asProjectile(Level world, Position pos, ItemStack stack, Direction direction) {
        FirmamentRejuvenatorEntity entity = new FirmamentRejuvenatorEntity(world, pos.x(), pos.y(), pos.z());
        entity.setItem(stack);
        return entity;
    }

    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().uncertainty(ProjectileItem.DispenseConfig.DEFAULT.uncertainty() * 0.1f).power(ProjectileItem.DispenseConfig.DEFAULT.power() * 1.5f).build();
    }
}

