/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.item;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.block.Block;

public class NetheritePumpkinItem
extends BlockItem
implements Equipable {
    protected final ArmorItem.Type type;
    protected final Holder<ArmorMaterial> material = ArmorMaterials.NETHERITE;
    private final Supplier<ItemAttributeModifiers> attributeModifiers;

    public NetheritePumpkinItem(Block block, Item.Properties settings) {
        super(block, settings);
        this.type = ArmorItem.Type.HELMET;
        this.attributeModifiers = Suppliers.memoize(() -> {
            int protection = 5;
            float toughness = ((ArmorMaterial)this.material.value()).toughness();
            float knockbackResistance = ((ArmorMaterial)this.material.value()).knockbackResistance();
            ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
            EquipmentSlotGroup attributeModifierSlot = EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot());
            ResourceLocation identifier = ResourceLocation.withDefaultNamespace((String)("armor." + this.type.getName()));
            builder.add(Attributes.ARMOR, new AttributeModifier(identifier, (double)protection, AttributeModifier.Operation.ADD_VALUE), attributeModifierSlot);
            builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(identifier, (double)toughness, AttributeModifier.Operation.ADD_VALUE), attributeModifierSlot);
            if (knockbackResistance > 0.0f) {
                builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(identifier, (double)knockbackResistance, AttributeModifier.Operation.ADD_VALUE), attributeModifierSlot);
            }
            return builder.build();
        });
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.attributeModifiers.get();
    }

    public ArmorItem.Type getType() {
        return this.type;
    }

    public Holder<ArmorMaterial> getMaterial() {
        return this.material;
    }

    public EquipmentSlot getEquipmentSlot() {
        return this.type.getSlot();
    }

    public Holder<SoundEvent> getEquipSound() {
        return ((ArmorMaterial)this.getMaterial().value()).equipSound();
    }
}

