/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.item;

import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import phanastrae.operation_starcleave.component.OperationStarcleaveComponentTypes;
import phanastrae.operation_starcleave.component.type.StarbleachComponent;
import phanastrae.operation_starcleave.entity.effect.OperationStarcleaveStatusEffects;
import phanastrae.operation_starcleave.item.OperationStarcleaveItems;

public class StarbleachCoating {
    public static void onEat(LivingEntity livingEntity, Level world, ItemStack itemStack) {
        if (world.isClientSide) {
            return;
        }
        if (StarbleachCoating.hasStarbleachCoating(itemStack)) {
            livingEntity.addEffect(new MobEffectInstance(OperationStarcleaveStatusEffects.STARBLEACHED_INSIDES_ENTRY, 200, 1));
        }
    }

    public static boolean hasStarbleachCoating(ItemStack itemStack) {
        return itemStack.has(OperationStarcleaveComponentTypes.STARBLEACH_COMPONENT);
    }

    public static void addStarbleach(ItemStack itemStack) {
        itemStack.set(OperationStarcleaveComponentTypes.STARBLEACH_COMPONENT, (Object)new StarbleachComponent());
    }

    public static boolean canAddStarbleach(ItemStack itemStack) {
        FoodProperties foodComponent = (FoodProperties)itemStack.get(DataComponents.FOOD);
        if (foodComponent == null) {
            return false;
        }
        if (StarbleachCoating.hasStarbleachCoating(itemStack)) {
            return false;
        }
        if (itemStack.is(OperationStarcleaveItems.STARBLEACH_BOTTLE)) {
            return false;
        }
        if (itemStack.is(OperationStarcleaveItems.STARFRUIT)) {
            return false;
        }
        return !itemStack.is(Items.CHORUS_FRUIT);
    }

    public static Component getText() {
        return StarbleachCoating.getText("operation_starcleave.tooltip.starbleached");
    }

    public static Component getText(String key) {
        float fl = (float)(System.currentTimeMillis() % 4000L) / 4000.0f;
        float red = Mth.sin((float)(fl * ((float)Math.PI * 2))) * 0.2f + 0.8f;
        float green = Mth.sin((float)((fl + 0.33333334f) * ((float)Math.PI * 2))) * 0.2f + 0.8f;
        float blue = Mth.sin((float)((fl + 0.6666667f) * ((float)Math.PI * 2))) * 0.2f + 0.8f;
        int r = (int)(red * 255.0f) & 0xFF;
        int g = (int)(green * 255.0f) & 0xFF;
        int b = (int)(blue * 255.0f) & 0xFF;
        return Component.translatable((String)key).withColor(r | g << 8 | b << 16 | 0xFF000000);
    }
}

