/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.item;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import phanastrae.operation_starcleave.entity.OperationStarcleaveDamageTypes;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;

public class StarfruitItem
extends Item {
    public static final FoodProperties STARFRUIT = new FoodProperties.Builder().nutrition(2).saturationModifier(0.5f).alwaysEdible().fast().build();

    public StarfruitItem(Item.Properties settings) {
        super(settings);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        ItemStack itemStack = super.finishUsingItem(stack, world, user);
        float yaw = user.getYRot() * (float)Math.PI / 180.0f;
        float pitch = user.getXRot() * (float)Math.PI / 180.0f;
        float cosYaw = Mth.cos((float)yaw);
        float sinYaw = Mth.sin((float)yaw);
        float cosPitch = Mth.cos((float)pitch);
        float sinPitch = Mth.sin((float)pitch);
        Vec3 lookVec = new Vec3((double)(-sinYaw * cosPitch), (double)(-sinPitch), (double)(cosYaw * cosPitch));
        if (!world.isClientSide) {
            if (user.isPassenger()) {
                user.stopRiding();
            }
            user.push(lookVec.scale(2.0));
            user.hurtMarked = true;
            user.fallDistance = -4.0f;
            Vec3 vec3d = user.position();
            world.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT, vec3d, GameEvent.Context.of((Entity)user));
            world.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.SPLASH_POTION_BREAK, SoundSource.PLAYERS);
            user.hurt(OperationStarcleaveDamageTypes.source(world, OperationStarcleaveDamageTypes.INTERNAL_STARBLEACHING), 4.0f);
        } else {
            Vec3 pos = user.getEyePosition();
            RandomSource random = user.getRandom();
            for (int i = 0; i < 500; ++i) {
                world.addParticle((ParticleOptions)OperationStarcleaveParticleTypes.FIRMAMENT_GLIMMER, pos.x, pos.y, pos.z, -lookVec.x * (double)0.1f + random.nextGaussian() * (double)0.2f, -lookVec.y * (double)0.1f + random.nextGaussian() * (double)0.2f, -lookVec.z * (double)0.1f + random.nextGaussian() * (double)0.2f);
            }
        }
        return itemStack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 12;
    }
}

