/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.mixin;

import net.minecraft.util.Mth;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import phanastrae.operation_starcleave.entity.OperationStarcleaveEntityAttachment;
import phanastrae.operation_starcleave.world.firmament.Firmament;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseMixin
extends Animal
implements ContainerListener,
HasCustomInventoryScreen,
OwnableEntity,
PlayerRideableJumping,
Saddleable {
    @Shadow
    protected boolean allowStandSliding;
    @Shadow
    protected float playerJumpPendingScale;

    @Shadow
    @Nullable
    public abstract LivingEntity getControllingPassenger();

    @Shadow
    public abstract void standIfPossible();

    @Shadow
    protected abstract void playJumpSound();

    protected AbstractHorseMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void operation_starcleave$handleGliding(CallbackInfo ci) {
        boolean isMidairPegasus;
        OperationStarcleaveEntityAttachment osea = OperationStarcleaveEntityAttachment.fromEntity((Entity)this);
        osea.setPrevPegasusWingSpread(osea.getPegasusWingSpread());
        osea.setPrevPegasusWingFlap(osea.getPegasusWingFlap());
        osea.setWasPegasusFlying(osea.isPegasusFlying());
        boolean isPegasus = OperationStarcleaveEntityAttachment.isPegasus((AbstractHorse)this);
        boolean bl = isMidairPegasus = isPegasus && !this.onGround();
        if (osea.isPegasusFlying() && osea.getPegasusFlightCharge() <= 0.0f) {
            osea.setPegasusFlying(false);
        }
        if (isPegasus) {
            if (osea.isPegasusFlying()) {
                osea.setPegasusFlightCharge(Math.max(osea.getPegasusFlightCharge() - 0.025f, 0.0f));
            } else {
                float starlight = this.operation_starcleave$calculateStarlight();
                float rechargeSpeed = this.onGround() ? 0.05f * (0.25f + 0.75f * starlight) : 0.00625f * (0.125f + 0.875f * starlight);
                float maxCharge = 0.5f + 0.5f * starlight;
                float oldCharge = osea.getPegasusFlightCharge();
                osea.setPegasusFlightCharge(Math.min(oldCharge + rechargeSpeed, Math.max(maxCharge, oldCharge - 0.00625f)));
            }
        } else {
            osea.setPegasusFlightCharge(0.0f);
        }
        if (!isPegasus && osea.getPegasusFlightCharge() != 0.0f) {
            osea.setPegasusFlightCharge(0.0f);
        }
        if (isMidairPegasus && this.fallDistance > 1.5f && !osea.isPegasusGliding()) {
            osea.setPegasusGliding(true);
        } else if (!isMidairPegasus && osea.isPegasusGliding()) {
            osea.setPegasusGliding(false);
        }
        if (osea.isPegasusGliding()) {
            this.fallDistance = -6.0f;
            osea.setPegasusWingSpread(Math.min(1.0f, osea.getPegasusWingSpread() + 0.08f));
        } else if (isPegasus) {
            osea.setPegasusWingSpread(Math.max(0.0f, osea.getPegasusWingSpread() - 0.14f));
        } else {
            osea.setPegasusWingSpread(0.0f);
        }
        if (osea.isPegasusFlying()) {
            osea.setPegasusWingFlap(Math.min(1.0f, osea.getPegasusWingFlap() + 0.4f));
        } else if (isPegasus) {
            osea.setPegasusWingFlap(Math.max(0.0f, osea.getPegasusWingFlap() - 0.15f));
        } else {
            osea.setPegasusWingFlap(0.0f);
        }
        if (this.isControlledByLocalInstance()) {
            if (osea.isPegasusFlying()) {
                AttributeInstance jumpStrengthAttribute = this.getAttribute(Attributes.JUMP_STRENGTH);
                double jumpStrength = jumpStrengthAttribute == null ? 0.0 : jumpStrengthAttribute.getValue();
                Vec3 dm = this.getDeltaMovement();
                this.setDeltaMovement(dm.x, dm.y > 0.6 ? dm.y : Math.min(dm.y + jumpStrength * 0.35, 0.6), dm.z);
            }
            if (osea.isPegasusGliding()) {
                Object control = this.getControllingPassenger();
                if (control == null) {
                    control = this;
                }
                Vec3 lookAngle = control.getLookAngle();
                Vec3 velocity = this.getDeltaMovement();
                Vec3 targetVelocity = lookAngle.scale(velocity.length());
                double turnScale = (osea.isPegasusFlying() ? 0.1 : 0.35) * (1.0 - lookAngle.y * lookAngle.y * lookAngle.y * lookAngle.y);
                Vec3 turnAcceleration = targetVelocity.subtract(velocity).scale(turnScale);
                this.addDeltaMovement(turnAcceleration);
                float starlight = this.operation_starcleave$calculateStarlight();
                double boostSpeed = 0.05 * (0.5 + 0.5 * (double)starlight) * (double)this.getSpeed();
                this.addDeltaMovement(lookAngle.multiply(1.0, 0.0, 1.0).scale(boostSpeed));
            }
        }
    }

    @Unique
    private float operation_starcleave$calculateStarlight() {
        float starlight;
        Level level = this.level();
        int skyLight = level.getBrightness(LightLayer.SKY, this.blockPosition());
        if (skyLight == 0) {
            starlight = 0.0f;
        } else {
            Firmament firmament = Firmament.fromLevel(this.level());
            if (firmament == null) {
                starlight = 0.0f;
            } else {
                int firmamentHeight = firmament.getY();
                double horseHeight = this.getY();
                double heightAboveFirmament = horseHeight - (double)firmamentHeight;
                float heightDropoff = 1.0f - (float)Math.clamp(heightAboveFirmament / 24.0, 0.0, 1.0);
                if (heightDropoff <= 0.0f) {
                    starlight = 0.0f;
                } else {
                    float SAMPLE_RADIUS = 3.5f;
                    int SEARCH_SIZE = Mth.ceil((float)SAMPLE_RADIUS);
                    int bx = this.getBlockX();
                    int bz = this.getBlockZ();
                    float damage = 0.0f;
                    for (int i = -SEARCH_SIZE; i <= SEARCH_SIZE; ++i) {
                        for (int j = -SEARCH_SIZE; j <= SEARCH_SIZE; ++j) {
                            int distSqr = i * i + j * j;
                            if (!((float)distSqr < SAMPLE_RADIUS * SAMPLE_RADIUS)) continue;
                            int x = bx + i * 4;
                            int z = bz + j * 4;
                            float d = (float)firmament.getDamage(x, z) / 7.0f;
                            damage = Math.max(damage, d -= Math.max(0.0f, 2.0f * Mth.sqrt((float)distSqr) / SAMPLE_RADIUS - 1.0f));
                        }
                    }
                    starlight = damage * ((float)skyLight / 15.0f) * heightDropoff;
                }
            }
        }
        return starlight;
    }

    @Inject(method={"getRiddenInput"}, at={@At(value="HEAD")}, cancellable=true)
    private void operation_starcleave$cancelInputWhileGliding(Player player, Vec3 travelVector, CallbackInfoReturnable<Vec3> cir) {
        OperationStarcleaveEntityAttachment osea = OperationStarcleaveEntityAttachment.fromEntity((Entity)this);
        if (osea.isPegasus() && osea.isPegasusGliding() && !osea.isPegasusFlying()) {
            cir.setReturnValue((Object)Vec3.ZERO);
        }
    }

    @Inject(method={"onPlayerJump"}, at={@At(value="HEAD")}, cancellable=true)
    private void operation_starcleave$onPlayerJump(int jumpPower, CallbackInfo ci) {
        OperationStarcleaveEntityAttachment osea = OperationStarcleaveEntityAttachment.fromEntity((Entity)this);
        if (osea.isPegasus()) {
            if (!osea.wasPegasusFlying() && osea.getPegasusFlightCharge() > 0.1f) {
                osea.setPegasusFlying(true);
                this.allowStandSliding = true;
                this.standIfPossible();
                if (this.onGround()) {
                    this.playerJumpPendingScale = 1.1f;
                }
            }
            ci.cancel();
        }
    }

    @Inject(method={"handleStartJump"}, at={@At(value="HEAD")}, cancellable=true)
    private void operation_starcleave$onHorseStartJump(int jumpPower, CallbackInfo ci) {
        OperationStarcleaveEntityAttachment osea = OperationStarcleaveEntityAttachment.fromEntity((Entity)this);
        if (osea.isPegasus()) {
            if (!osea.wasPegasusFlying() && osea.getPegasusFlightCharge() > 0.1f) {
                osea.setPegasusFlying(true);
                this.allowStandSliding = true;
                this.standIfPossible();
                this.playJumpSound();
            }
            ci.cancel();
        }
    }

    @Inject(method={"handleStopJump"}, at={@At(value="HEAD")})
    private void operation_starcleave$onHorseStopJump(CallbackInfo ci) {
        OperationStarcleaveEntityAttachment osea = OperationStarcleaveEntityAttachment.fromEntity((Entity)this);
        osea.setPegasusFlying(false);
    }
}

