/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.mixin;

import com.mojang.authlib.GameProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import phanastrae.operation_starcleave.entity.OperationStarcleaveEntityAttachment;
import phanastrae.operation_starcleave.world.firmament.FirmamentRegionsWatched;
import phanastrae.operation_starcleave.world.firmament.FirmamentWatcher;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player
implements FirmamentWatcher {
    @Unique
    private FirmamentRegionsWatched operation_starcleave$watched_regions;

    public ServerPlayerMixin(Level level, BlockPos pos, float yRot, GameProfile gameProfile) {
        super(level, pos, yRot, gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void operation_starcleave$onInit(MinecraftServer server, ServerLevel world, GameProfile profile, ClientInformation clientOptions, CallbackInfo ci) {
        this.operation_starcleave$watched_regions = new FirmamentRegionsWatched((ServerPlayer)this);
    }

    @Inject(method={"restoreFrom"}, at={@At(value="RETURN")})
    private void operation_starcleave$restoreFrom(ServerPlayer oldPlayer, boolean alive, CallbackInfo ci) {
        OperationStarcleaveEntityAttachment.fromEntity((Entity)this).restoreFromOldServerPlayer(oldPlayer, alive);
    }

    @Inject(method={"changeDimension"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;sendActivePlayerEffects(Lnet/minecraft/server/level/ServerPlayer;)V", shift=At.Shift.AFTER)})
    private void operation_starcleave$afterChangingDimension(DimensionTransition teleportTarget, CallbackInfoReturnable<Entity> cir) {
        ServerPlayer player = (ServerPlayer)this;
        OperationStarcleaveEntityAttachment.fromEntity((Entity)this).afterServerPlayerChangingDimension(player);
    }

    @Inject(method={"die"}, at={@At(value="RETURN")})
    private void operation_starcleave$onDeath(DamageSource damageSource, CallbackInfo ci) {
        OperationStarcleaveEntityAttachment.fromEntity((Entity)this).onServerPlayerDeath();
    }

    @Override
    public FirmamentRegionsWatched operation_starcleave$getWatchedRegions() {
        return this.operation_starcleave$watched_regions;
    }
}

