/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.world.firmament;

import org.jetbrains.annotations.Nullable;
import phanastrae.operation_starcleave.world.firmament.FirmamentRegion;

public class FirmamentRegionHolder {
    private final FirmamentRegion firmamentRegion;
    private long lastAccessTime;
    private volatile FirmamentRegionState state;

    public FirmamentRegionHolder(FirmamentRegion firmamentRegion) {
        this.firmamentRegion = firmamentRegion;
        this.setState(FirmamentRegionState.NOT_STARTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirmamentRegionState getState() {
        FirmamentRegionHolder firmamentRegionHolder = this;
        synchronized (firmamentRegionHolder) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(FirmamentRegionState state) {
        FirmamentRegionHolder firmamentRegionHolder = this;
        synchronized (firmamentRegionHolder) {
            this.state = state;
        }
    }

    @Nullable
    public FirmamentRegion getFirmamentRegion() {
        if (this.getState() == FirmamentRegionState.STARTED) {
            return this.firmamentRegion;
        }
        return null;
    }

    public void recordAccess() {
        this.lastAccessTime = this.firmamentRegion.firmament.getLevel().getGameTime();
    }

    public long getTimeSinceLastAccess(long currentTime) {
        return currentTime - this.lastAccessTime;
    }

    public static enum FirmamentRegionState {
        NOT_STARTED,
        LOADING,
        READY_TO_START,
        STARTED;

    }
}

