/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.world.firmament;

import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.util.TriConsumer;
import phanastrae.operation_starcleave.entity.NuclearStormcloudEntity;
import phanastrae.operation_starcleave.world.OperationStarcleaveGameRules;
import phanastrae.operation_starcleave.world.firmament.Firmament;
import phanastrae.operation_starcleave.world.firmament.FirmamentActor;
import phanastrae.operation_starcleave.world.firmament.FirmamentUpdater;

public class FirmamentShatterActor
extends FirmamentActor {
    public float damagePotential;
    public float initialDamagePotential;
    public int initialDelay = 0;
    public int trueOriginX;
    public int trueOriginZ;
    public float dx;
    public float dz;
    public Random random = new Random();

    public FirmamentShatterActor(Firmament firmament, int originX, int originZ, float dx, float dz, float damagePotential) {
        this(firmament, originX, originZ, dx, dz, damagePotential, originX, originZ, damagePotential);
    }

    public FirmamentShatterActor(Firmament firmament, int originX, int originZ, float dx, float dz, float damagePotential, int trueOriginX, int trueOriginZ, float initialDamagePotential) {
        super(firmament, originX, originZ);
        this.damagePotential = damagePotential;
        this.initialDamagePotential = initialDamagePotential;
        this.dx = dx;
        this.dz = dz;
        this.trueOriginX = trueOriginX;
        this.trueOriginZ = trueOriginZ;
    }

    @Override
    public void tick() {
        Level world = this.firmament.getLevel();
        if (this.damagePotential < 1.0E-4f) {
            this.discard();
            return;
        }
        if (this.initialDelay > 0) {
            --this.initialDelay;
            return;
        }
        if (this.random.nextFloat() > 0.9f) {
            this.split();
            this.discard();
            return;
        }
        double theta = (double)this.random.nextFloat() * Math.PI * 2.0;
        float ddx = (float)org.joml.Math.cos((double)theta);
        float ddz = (float)org.joml.Math.sin((double)theta);
        float dSqr = this.dx * this.dx + this.dz * this.dz;
        float dNorm = dSqr == 0.0f ? 0.0f : 1.0f / org.joml.Math.sqrt((float)dSqr);
        float dot = (this.dx * ddx + this.dz * ddz) * dNorm;
        float f = dot * dot * dot;
        int n = this.random.nextInt(4, 12);
        for (int i = 0; i < n; ++i) {
            int z;
            int x;
            float dFdz;
            float dFdx = FirmamentUpdater.dFdxBigDamage(this.firmament, this.originX + (int)this.dx, this.originZ + (int)this.dz);
            float dFSqr = dFdx * dFdx + (dFdz = FirmamentUpdater.dFdzBigDamage(this.firmament, this.originX + (int)this.dx, this.originZ + (int)this.dz)) * dFdz;
            float dFnorm = dFSqr == 0.0f ? 0.0f : 1.0f / org.joml.Math.sqrt((float)dFSqr);
            float dot2 = (ddx * dFdx + ddz * dFdz) * dFnorm;
            float g = (1.0f - dot2 * dot2 * dot2) / 2.0f;
            this.dx += ddx * f * g * 4.0f;
            this.dz += ddz * f * g * 4.0f;
            int idx = this.originX + (int)this.dx;
            int idz = this.originZ + (int)this.dz;
            float addDamage = org.joml.Math.clamp((float)1.0f, (float)15.0f, (float)(this.damagePotential * this.damagePotential / this.initialDamagePotential));
            this.damagePotential -= addDamage;
            int damage = this.firmament.getDamage(idx, idz);
            if (damage < 7) {
                int d = org.joml.Math.clamp((int)0, (int)7, (int)(damage + (int)addDamage));
                this.firmament.setDamage(idx, idz, d);
                if (d == 7) {
                    this.trySpawnStormcloud(this.firmament.getLevel(), 2 + idx, 2 + idz);
                }
            }
            this.firmament.markActive(idx, idz);
            FirmamentUpdater.forEachNeighbor((TriConsumer<Integer, Integer, Float>)((TriConsumer)(nx, nz, nWeight) -> {
                float addDamage2 = addDamage * 0.5f * nWeight.floatValue();
                int damage2 = this.firmament.getDamage(idx + nx, idz + nz);
                if (damage2 < 7) {
                    int d2 = org.joml.Math.clamp((int)0, (int)7, (int)(damage2 + (int)addDamage2));
                    this.firmament.setDamage(idx + nx, idz + nz, d2);
                    if (d2 == 7) {
                        this.trySpawnStormcloud(this.firmament.getLevel(), 2 + idx + nx, 2 + idz + nz);
                    }
                }
            }));
            int maxNearDrip = 0;
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    int dam = this.firmament.getDamage(idx + x * 4, idz + z * 4);
                    if (maxNearDrip >= dam) continue;
                    maxNearDrip = dam;
                }
            }
            for (x = -3; x <= 3; ++x) {
                for (z = -3; z <= 3; ++z) {
                    float dist = x * x + z * z;
                    double falloff = org.joml.Math.exp((double)(-dist * 0.2f));
                    int d = (int)((double)maxNearDrip * falloff);
                    if (this.firmament.getDrip(idx + x * 4, idz + z * 4) >= d) continue;
                    this.firmament.setDrip(idx + x * 4, idz + z * 4, d);
                    this.firmament.markActive(idx + x * 4, idz + z * 4);
                }
            }
        }
    }

    public void split() {
        int hdx = (int)(this.dx * 0.9f);
        int hdz = (int)(this.dz * 0.9f);
        int ddp = (int)(this.damagePotential * (this.random.nextFloat() * 0.6f + 0.3f));
        float dx2 = this.dx - (float)hdx;
        float dz2 = this.dz - (float)hdz;
        FirmamentShatterActor actor1 = new FirmamentShatterActor(this.firmament, this.originX + hdx, this.originZ + hdz, dx2, dz2, this.damagePotential - (float)ddp, this.trueOriginX, this.trueOriginZ, this.initialDamagePotential);
        FirmamentShatterActor actor2 = new FirmamentShatterActor(this.firmament, this.originX + hdx, this.originZ + hdz, dx2, dz2, ddp, this.trueOriginX, this.trueOriginZ, this.initialDamagePotential);
        this.firmament.addActor(actor1);
        this.firmament.addActor(actor2);
    }

    public void trySpawnStormcloud(Level level, int x, int z) {
        if (level.getGameRules().getBoolean(OperationStarcleaveGameRules.SPAWN_FRACTURE_BYPRODUCTS) && this.random.nextInt(25) == 0) {
            int y = this.firmament.getY();
            NuclearStormcloudEntity stormcloud = new NuclearStormcloudEntity(level, x, y, z);
            level.addFreshEntity((Entity)stormcloud);
        }
    }
}

