/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.world.firmament;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.util.TriConsumer;
import phanastrae.operation_starcleave.network.packet.UpdateFirmamentSubRegionPayload;
import phanastrae.operation_starcleave.services.XPlatInterface;
import phanastrae.operation_starcleave.world.firmament.FirmamentAccess;
import phanastrae.operation_starcleave.world.firmament.FirmamentActor;
import phanastrae.operation_starcleave.world.firmament.FirmamentRegion;
import phanastrae.operation_starcleave.world.firmament.FirmamentSubRegionData;
import phanastrae.operation_starcleave.world.firmament.FirmamentWatcher;
import phanastrae.operation_starcleave.world.firmament.RegionPos;
import phanastrae.operation_starcleave.world.firmament.SubRegionPos;

public class FirmamentSubRegion
implements FirmamentAccess {
    public static final int SUBREGION_SIZE = 32;
    public static final int TILES = 8;
    public static final int TILE_MASK = 3;
    public static final int TILE_SIZE_BITS = 2;
    public static final int TILE_SIZE = 4;
    public static final int DATA_SIZE_BYTES = 64;
    public final int[] xOffset = new int[]{-1, 0, 32, -1, 0, 32, -1, 0, 32};
    public final int[] zOffset = new int[]{-1, -1, -1, 0, 0, 0, 32, 32, 32};
    public int[][] velocity;
    public int[][] displacement;
    public int[][] damage;
    public int[][] drip;
    public float[][] dDrip;
    private final List<FirmamentActor> actors = new ArrayList<FirmamentActor>();
    private final List<FirmamentActor> newActors = new ArrayList<FirmamentActor>();
    boolean[] active = new boolean[9];
    boolean shouldUpdate = false;
    boolean pendingClientUpdate = false;
    boolean hadDamageLastCheck = false;
    public final int x;
    public final int z;
    public final FirmamentRegion firmamentRegion;

    public FirmamentSubRegion(FirmamentRegion firmamentRegion, int x, int z) {
        this.firmamentRegion = firmamentRegion;
        this.x = x;
        this.z = z;
        this.displacement = new int[8][8];
        this.velocity = new int[8][8];
        this.damage = new int[8][8];
        this.drip = new int[8][8];
        this.dDrip = new float[8][8];
    }

    public void clear() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.damage[i][j] = 0;
                this.drip[i][j] = 0;
                this.dDrip[i][j] = 0.0f;
                this.displacement[i][j] = 0;
                this.velocity[i][j] = 0;
            }
        }
        this.pendingClientUpdate = true;
        this.firmamentRegion.pendingClientUpdate = true;
        this.clearActors();
    }

    public void markShouldUpdate() {
        this.shouldUpdate = true;
    }

    @Override
    public void clearActors() {
        this.actors.clear();
        this.newActors.clear();
    }

    @Override
    public void addActor(FirmamentActor actor) {
        this.newActors.add(actor);
    }

    @Override
    public void manageActors() {
        this.actors.addAll(this.newActors);
        this.newActors.clear();
        this.actors.removeIf(actor -> !actor.isActive());
    }

    @Override
    public void tickActors() {
        for (FirmamentActor actor : this.actors) {
            if (!actor.isActive()) continue;
            actor.tick();
        }
    }

    @Override
    public void forEachActor(Consumer<FirmamentActor> consumer) {
        for (FirmamentActor actor : this.actors) {
            consumer.accept(actor);
        }
    }

    @Override
    public void forEachPosition(BiConsumer<Integer, Integer> method) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                method.accept(i * 4, j * 4);
            }
        }
    }

    public void forEachPosition(TriConsumer<Integer, Integer, Boolean> method) {
        for (int i = 0; i < 8; ++i) {
            boolean b1 = i == 0 || i == 7;
            for (int j = 0; j < 8; ++j) {
                boolean b2 = j == 0 || j == 7;
                boolean onBorder = b1 || b2;
                method.accept((Object)(i * 4), (Object)(j * 4), (Object)onBorder);
            }
        }
    }

    @Override
    public void forEachActivePosition(BiConsumer<Integer, Integer> method) {
        this.forEachPosition(method);
    }

    @Override
    public int getDrip(int x, int z) {
        return this.drip[x >> 2][z >> 2];
    }

    @Override
    public int getDamage(int x, int z) {
        return this.damage[x >> 2][z >> 2];
    }

    @Override
    public int getDisplacement(int x, int z) {
        return this.displacement[x >> 2][z >> 2];
    }

    @Override
    public int getVelocity(int x, int z) {
        return this.velocity[x >> 2][z >> 2];
    }

    @Override
    public float getDDrip(int x, int z) {
        return this.dDrip[x >> 2][z >> 2];
    }

    @Override
    public void setDrip(int x, int z, int value) {
        this.drip[x >> 2][z >> 2] = value;
    }

    @Override
    public void setDamage(int x, int z, int value) {
        this.pendingClientUpdate = true;
        this.damage[x >> 2][z >> 2] = value;
    }

    @Override
    public void setDisplacement(int x, int z, int value) {
        this.displacement[x >> 2][z >> 2] = value;
    }

    @Override
    public void setVelocity(int x, int z, int value) {
        this.velocity[x >> 2][z >> 2] = value;
    }

    @Override
    public void setDDrip(int x, int z, float value) {
        this.dDrip[x >> 2][z >> 2] = value;
    }

    @Override
    public void markShouldUpdate(int x, int z) {
        this.markShouldUpdate();
    }

    @Override
    public void clearShouldUpdate() {
        this.shouldUpdate = false;
    }

    @Override
    public boolean shouldUpdate() {
        return this.shouldUpdate;
    }

    @Override
    public void markActive(int x, int z) {
        int tx = x >> 2;
        int tz = z >> 2;
        boolean xMin = tx == 0;
        boolean zMin = tz == 7;
        boolean xMax = tx == 0;
        boolean zMax = tz == 7;
        this.active[4] = true;
        if (xMin) {
            this.active[3] = true;
            if (zMin) {
                this.active[0] = true;
            }
            if (zMax) {
                this.active[6] = true;
            }
        }
        if (xMax) {
            this.active[5] = true;
            if (zMin) {
                this.active[2] = true;
            }
            if (zMax) {
                this.active[8] = true;
            }
        }
        if (zMin) {
            this.active[1] = true;
        }
        if (zMax) {
            this.active[7] = true;
        }
    }

    @Override
    public void clearActive() {
        for (int i = 0; i < 9; ++i) {
            this.active[i] = false;
        }
    }

    @Override
    public void markUpdatesFromActivity() {
        for (int k = 0; k < 9; ++k) {
            if (!this.active[k]) continue;
            this.firmamentRegion.firmament.markShouldUpdate(this.x + this.xOffset[k], this.z + this.zOffset[k]);
        }
    }

    public long getPosAsLong() {
        int srx = this.x >> 5;
        int srz = this.z >> 5;
        return (long)srx & 0xFFFFFFFFL | (long)srz << 32;
    }

    public byte[] getAsByteArray(int[][] target) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(64);
        boolean multipleValues = false;
        byte val = (byte)target[0][0];
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                byte b = (byte)target[i][j];
                byteBuffer.put(b);
                if (b == val) continue;
                multipleValues = true;
            }
        }
        if (multipleValues) {
            return byteBuffer.array();
        }
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.put(val);
        return buffer.array();
    }

    public void readFromData(FirmamentSubRegionData firmamentSubRegionData) {
        this.readFromByteArray(firmamentSubRegionData.damageData, this.damage, 7);
        this.checkDamage();
    }

    public void readFromByteArray(byte[] byteArray, int[][] targetArray, int mask) {
        block6: {
            block5: {
                if (byteArray == null) {
                    return;
                }
                if (byteArray.length != 64) break block5;
                ByteBuffer byteBuffer = ByteBuffer.allocate(64);
                byteBuffer.put(byteArray);
                byteBuffer.position(0);
                for (int i = 0; i < 8; ++i) {
                    for (int j = 0; j < 8; ++j) {
                        targetArray[i][j] = byteBuffer.get() & mask;
                    }
                }
                break block6;
            }
            if (byteArray.length != 1) break block6;
            int val = byteArray[0] & mask;
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    targetArray[i][j] = val;
                }
            }
        }
    }

    public void flushUpdates() {
        if (this.pendingClientUpdate) {
            this.pendingClientUpdate = false;
            Level world = this.firmamentRegion.firmament.getLevel();
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                SubRegionPos subRegionPos = SubRegionPos.fromWorldCoords(this.x, this.z);
                RegionPos regionPos = RegionPos.fromSubRegion(subRegionPos);
                ArrayList nearbyPlayers = new ArrayList();
                serverWorld.players().forEach(serverPlayerEntity -> {
                    if (((FirmamentWatcher)serverPlayerEntity).operation_starcleave$getWatchedRegions().watchedRegions.contains(regionPos.id)) {
                        nearbyPlayers.add(serverPlayerEntity);
                    }
                });
                if (!nearbyPlayers.isEmpty()) {
                    FirmamentSubRegionData data = new FirmamentSubRegionData(this);
                    nearbyPlayers.forEach(serverPlayerEntity -> XPlatInterface.INSTANCE.sendPayload((ServerPlayer)serverPlayerEntity, new UpdateFirmamentSubRegionPayload(subRegionPos.id, data)));
                }
            }
        }
    }

    public void checkDamage() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (this.damage[i][j] == 0) continue;
                this.hadDamageLastCheck = true;
                return;
            }
        }
        this.hadDamageLastCheck = false;
    }

    public boolean hadDamageLastCheck() {
        return this.hadDamageLastCheck;
    }
}

