/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.world.firmament;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Math;
import phanastrae.operation_starcleave.world.firmament.Firmament;

public class FirmamentUpdater {
    public static final int nCount = 8;
    public static final int[] nXs = new int[]{4, -4, 0, 0, 4, 4, -4, -4};
    public static final int[] nZs = new int[]{0, 0, 4, -4, 4, -4, 4, -4};
    static final float aw = 0.1464f;
    static final float dw = 0.1036f;
    public static final float[] nWeights = new float[]{0.1464f, 0.1464f, 0.1464f, 0.1464f, 0.1036f, 0.1036f, 0.1036f, 0.1036f};

    public static void update(Firmament firmament) {
        int TILE_SIZE = 4;
        firmament.forEachActivePosition((x, z) -> {
            int newVelocity;
            int velocity;
            float drip = firmament.getDrip((int)x, (int)z);
            if (drip == 0.0f) {
                return;
            }
            int damage = firmament.getDamage((int)x, (int)z);
            float displacement = firmament.getDisplacement((int)x, (int)z);
            float force = 16.0f * ((float)damage / 7.0f);
            for (int n = 0; n < 8; ++n) {
                float displacement2 = firmament.getDisplacement(x + nXs[n], z + nZs[n]);
                int damage2 = firmament.getDamage(x + nXs[n], z + nZs[n]);
                float dDisplacement = displacement2 - displacement;
                float f = (1.0f - (float)damage2 / 7.0f) * (1.0f - (float)damage / 7.0f);
                force += 16.0f * (dDisplacement / 15.0f) * nWeights[n] * f;
            }
            float dv = (force *= (displacement * displacement / 215.0f + 1.0f) / 2.0f) * (drip / 7.0f) * 4.0f;
            if (dv < 0.0f) {
                dv *= 0.25f;
            }
            if (((velocity = firmament.getVelocity((int)x, (int)z)) < 7 || dv < 0.0f) && dv != 0.0f && (newVelocity = Math.clamp((int)0, (int)7, (int)(velocity + (int)dv))) != velocity) {
                firmament.setVelocity((int)x, (int)z, newVelocity);
                firmament.markActive((int)x, (int)z);
            }
        });
        firmament.forEachActivePosition((x, z) -> {
            int currentDamage;
            int newDisplacement;
            int d = firmament.getDisplacement((int)x, (int)z);
            int dh = firmament.getVelocity((int)x, (int)z) / 4;
            if (d < 15 && dh != 0 && (newDisplacement = Math.clamp((int)0, (int)15, (int)(d + dh))) != d) {
                d = newDisplacement;
                firmament.setDisplacement((int)x, (int)z, d);
                firmament.markActive((int)x, (int)z);
            }
            int threshold = Math.clamp((int)0, (int)7, (int)(dh / 4));
            if (d == 15 && (threshold = firmament.getDamage((int)x, (int)z) + 1) > 7) {
                threshold = 7;
            }
            if ((currentDamage = firmament.getDamage((int)x, (int)z)) < threshold) {
                firmament.setDamage((int)x, (int)z, threshold);
                firmament.markActive((int)x, (int)z);
            }
        });
        firmament.forEachActivePosition((x, z) -> {
            AtomicReference<Integer> maxPotentialDrip = new AtomicReference<Integer>(0);
            FirmamentUpdater.forEachNeighbor((TriConsumer<Integer, Integer, Float>)((TriConsumer)(nx, nz, nWeight) -> {
                int nDrip = firmament.getDrip(x + nx, z + nz);
                int potentialDrip = nDrip - 1;
                if (potentialDrip > (Integer)maxPotentialDrip.get()) {
                    maxPotentialDrip.set(potentialDrip);
                }
            }));
            firmament.setDDrip((int)x, (int)z, maxPotentialDrip.get().intValue());
        });
        firmament.forEachActivePosition((x, z) -> {
            int drip = firmament.getDrip((int)x, (int)z);
            int newDrip = Math.clamp((int)0, (int)7, (int)((int)firmament.getDDrip((int)x, (int)z)));
            if (newDrip > drip) {
                firmament.setDrip((int)x, (int)z, newDrip);
                firmament.markActive((int)x, (int)z);
            }
            firmament.setDDrip((int)x, (int)z, 0.0f);
        });
    }

    public static void forEachNeighbor(TriConsumer<Integer, Integer, Float> method) {
        for (int n = 0; n < 8; ++n) {
            int nx = nXs[n];
            int nz = nZs[n];
            float nWeight = nWeights[n];
            method.accept((Object)nx, (Object)nz, (Object)Float.valueOf(nWeight));
        }
    }

    public static float dFdxDamage(Firmament firmament, int x, int z) {
        return (float)(firmament.getDamage(x + 1, z) - firmament.getDamage(x - 1, z)) / 2.0f;
    }

    public static float dFdzDamage(Firmament firmament, int x, int z) {
        return (float)(firmament.getDamage(x, z + 1) - firmament.getDamage(x, z - 1)) / 2.0f;
    }

    public static float dFdxBigDamage(Firmament firmament, int x, int z) {
        return 0.5f * FirmamentUpdater.dFdxDamage(firmament, x, z) + 0.25f * (FirmamentUpdater.dFdxDamage(firmament, x + 1, z) + FirmamentUpdater.dFdxDamage(firmament, x - 1, z));
    }

    public static float dFdzBigDamage(Firmament firmament, int x, int z) {
        return 0.5f * FirmamentUpdater.dFdzDamage(firmament, x, z) + 0.25f * (FirmamentUpdater.dFdzDamage(firmament, x, z + 1) + FirmamentUpdater.dFdzDamage(firmament, x, z - 1));
    }
}

