/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.operation_starcleave.world.starbleach;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;
import phanastrae.operation_starcleave.block.OperationStarcleaveBlocks;
import phanastrae.operation_starcleave.block.StarbleachCauldronBlock;
import phanastrae.operation_starcleave.block.StellarFarmlandBlock;
import phanastrae.operation_starcleave.block.tag.OperationStarcleaveBlockTags;
import phanastrae.operation_starcleave.particle.OperationStarcleaveParticleTypes;
import phanastrae.operation_starcleave.world.OperationStarcleaveGameRules;
import phanastrae.operation_starcleave.world.firmament.Firmament;
import phanastrae.operation_starcleave.world.firmament.FirmamentSubRegion;
import phanastrae.operation_starcleave.world.firmament.SubRegionPos;

public class Starbleach {
    public static StarbleachTarget getFractureStarbleachTarget(ServerLevel world) {
        boolean bl = world.getGameRules().getBoolean(OperationStarcleaveGameRules.DO_FRACTURE_STARBLEACHING);
        return bl ? StarbleachTarget.ALL : StarbleachTarget.ONLY_FILLING;
    }

    public static void starbleachChunk(ServerLevel world, LevelChunk chunk, int randomTickSpeed) {
        Firmament firmament = Firmament.fromLevel((Level)world);
        if (firmament == null) {
            return;
        }
        world.getProfiler().popPush("starcleave_starbleach");
        ChunkPos chunkPos = chunk.getPos();
        int i = chunkPos.getMinBlockX();
        int j = chunkPos.getMinBlockZ();
        SubRegionPos subRegionPos = SubRegionPos.fromWorldCoords(i, j);
        FirmamentSubRegion subRegion = firmament.getSubRegionFromId(subRegionPos.id);
        if (subRegion == null) {
            return;
        }
        StarbleachTarget starbleachTarget = Starbleach.getFractureStarbleachTarget(world);
        for (int k = 0; k < randomTickSpeed; ++k) {
            BlockPos blockPos;
            int damage;
            if (world.random.nextInt(300) != 0 || (damage = subRegion.getDamage((blockPos = world.getBlockRandomPos(i, 0, j, 15)).getX() & 0x1F, blockPos.getZ() & 0x1F)) < 5) continue;
            int topY = world.getHeight(Heightmap.Types.MOTION_BLOCKING, blockPos.getX(), blockPos.getZ());
            BlockPos targetPos = new BlockPos(blockPos.getX(), topY - 1, blockPos.getZ());
            Starbleach.starbleach(world, targetPos, starbleachTarget, 150);
        }
    }

    public static void starbleach(ServerLevel world, BlockPos blockPos, StarbleachTarget starbleachTarget, int particleCount) {
        BlockState newState;
        BlockState blockState = world.getBlockState(blockPos);
        if (Starbleach.isStarbleached(blockState)) {
            if ((starbleachTarget == StarbleachTarget.ALL || starbleachTarget == StarbleachTarget.NO_FILLING) && world.random.nextInt(5) == 0) {
                Starbleach.decorate(world, blockPos.above(), 5, OperationStarcleaveBlocks.HOLY_MOSS, OperationStarcleaveBlocks.SHORT_HOLY_MOSS);
                Starbleach.decorate(world, blockPos.above(), 10, OperationStarcleaveBlocks.STELLAR_MULCH, OperationStarcleaveBlocks.MULCHBORNE_TUFT);
                return;
            }
            boolean starbleached = true;
            for (int k = 0; k < 12 && starbleached; ++k) {
                if (world.random.nextInt(6) == 0) {
                    int x = 0;
                    int z = 0;
                    switch (world.random.nextInt(4)) {
                        case 0: {
                            x = 1;
                            break;
                        }
                        case 1: {
                            x = -1;
                            break;
                        }
                        case 2: {
                            z = 1;
                            break;
                        }
                        case 3: {
                            z = -1;
                        }
                    }
                    blockPos = blockPos.offset(x, 0, z);
                } else {
                    blockPos = blockPos.offset(0, -1, 0);
                }
                blockState = world.getBlockState(blockPos);
                for (int k2 = 0; k2 < 8; ++k2) {
                    if (!blockState.isAir()) continue;
                    blockPos = blockPos.offset(0, -1, 0);
                    blockState = world.getBlockState(blockPos);
                }
                if (Starbleach.isStarbleached(blockState)) continue;
                starbleached = false;
            }
            if (starbleached) {
                return;
            }
        }
        if ((newState = Starbleach.getStarbleachResult((Level)world, blockPos, blockState, world.random, starbleachTarget)) != null) {
            if (newState.isAir()) {
                world.destroyBlock(blockPos, false);
            } else {
                world.setBlockAndUpdate(blockPos, newState);
            }
            world.playSeededSound(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 0.1f, 1.6f + 0.4f * world.random.nextFloat(), world.random.nextLong());
            for (Direction direction : Direction.values()) {
                Vec3i v = direction.getNormal();
                if (!world.getBlockState(blockPos.offset(v)).canBeReplaced()) continue;
                double x = (double)blockPos.getX() + 0.5 + 0.5 * (double)v.getX();
                double y = (double)blockPos.getY() + 0.5 + 0.5 * (double)v.getY();
                double z = (double)blockPos.getZ() + 0.5 + 0.5 * (double)v.getZ();
                world.sendParticles((ParticleOptions)OperationStarcleaveParticleTypes.FIRMAMENT_GLIMMER, x, y, z, particleCount, v.getX() == 0 ? 0.5 : 0.0, v.getY() == 0 ? 0.5 : 0.0, v.getZ() == 0 ? 0.5 : 0.0, 0.05);
            }
        }
    }

    public static void decorate(ServerLevel world, BlockPos blockPos, int threshold, Block baseBlock, Block decoBlock) {
        int nearby = 0;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int k = -2; k <= 2; ++k) {
                    if (i * i + j * j + k * k > 6 || !world.getBlockState(blockPos.offset(i, j, k)).is(decoBlock)) continue;
                    ++nearby;
                }
            }
        }
        if (nearby > threshold) {
            return;
        }
        if (world.getBlockState(blockPos).isAir() && world.getBlockState(blockPos.below()).is(baseBlock)) {
            world.setBlockAndUpdate(blockPos, decoBlock.defaultBlockState());
        }
    }

    public static boolean isStarbleached(BlockState blockState) {
        return blockState.is(OperationStarcleaveBlockTags.STARBLEACHED);
    }

    @Nullable
    public static BlockState getStarbleachResult(Level world, BlockPos blockPos, BlockState blockState, RandomSource random, StarbleachTarget starbleachTarget) {
        BlockState newBlockstate = null;
        if ((starbleachTarget == StarbleachTarget.ALL || starbleachTarget == StarbleachTarget.ONLY_FILLING) && (newBlockstate = Starbleach.getStarbleachCauldronResult(blockState)) != null) {
            return newBlockstate;
        }
        if ((starbleachTarget == StarbleachTarget.ALL || starbleachTarget == StarbleachTarget.NO_FILLING) && (newBlockstate = Starbleach.getStarbleachBlockResult(world, blockPos, blockState, random)) != null) {
            return newBlockstate;
        }
        return newBlockstate;
    }

    @Nullable
    public static BlockState getStarbleachCauldronResult(BlockState blockState) {
        if (blockState.is(Blocks.CAULDRON)) {
            return OperationStarcleaveBlocks.STARBLEACH_CAULDRON.defaultBlockState();
        }
        if (blockState.is(OperationStarcleaveBlocks.STARBLEACH_CAULDRON) && (Integer)blockState.getValue((Property)StarbleachCauldronBlock.LEVEL_7) != 7) {
            return (BlockState)blockState.cycle((Property)StarbleachCauldronBlock.LEVEL_7);
        }
        return null;
    }

    @Nullable
    public static BlockState getStarbleachBlockResult(Level world, BlockPos blockPos, BlockState blockState, RandomSource random) {
        if (blockState.is(OperationStarcleaveBlockTags.STARBLEACH_IMMUNE)) {
            return null;
        }
        if (blockState.is(Blocks.PODZOL) || blockState.is(Blocks.MYCELIUM)) {
            return OperationStarcleaveBlocks.STELLAR_MULCH.defaultBlockState();
        }
        if (blockState.is(Blocks.GRASS_BLOCK)) {
            int steepness = 0;
            for (Direction direction : Direction.values()) {
                BlockState state;
                if (direction.getAxis() == Direction.Axis.Y || (state = world.getBlockState(blockPos.offset(direction.getStepX(), 1, direction.getStepZ()))).canBeReplaced()) continue;
                ++steepness;
            }
            if (random.nextInt(2 + steepness) >= 2) {
                return OperationStarcleaveBlocks.STELLAR_MULCH.defaultBlockState();
            }
            int nearbyMulch = 0;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockState state = world.getBlockState(blockPos.offset(x, 0, z));
                    if (!state.is(OperationStarcleaveBlocks.STELLAR_MULCH)) continue;
                    ++nearbyMulch;
                }
            }
            if (random.nextInt(1 + (9 - nearbyMulch) * (9 - nearbyMulch)) <= 2) {
                return OperationStarcleaveBlocks.STELLAR_MULCH.defaultBlockState();
            }
            return OperationStarcleaveBlocks.HOLY_MOSS.defaultBlockState();
        }
        if (blockState.is(Blocks.DIRT) || blockState.is(Blocks.COARSE_DIRT) || blockState.is(Blocks.ROOTED_DIRT) || blockState.is(BlockTags.BASE_STONE_OVERWORLD) || blockState.is(Blocks.END_STONE)) {
            if (world.getBlockState(blockPos.above()).isAir()) {
                int nearbyMulch = 0;
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockState state = world.getBlockState(blockPos.offset(x, 0, z));
                        if (!state.is(OperationStarcleaveBlocks.STELLAR_MULCH)) continue;
                        ++nearbyMulch;
                    }
                }
                if (random.nextInt(1 + (9 - nearbyMulch) * (9 - nearbyMulch)) <= 30) {
                    return OperationStarcleaveBlocks.STELLAR_MULCH.defaultBlockState();
                }
            }
            return OperationStarcleaveBlocks.STELLAR_SEDIMENT.defaultBlockState();
        }
        if (blockState.is(Blocks.NETHERRACK) || blockState.is(Blocks.SOUL_SAND) || blockState.is(Blocks.SOUL_SOIL) || blockState.is(Blocks.CRIMSON_NYLIUM) || blockState.is(Blocks.WARPED_NYLIUM)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (blockState.is(BlockTags.SAND) || blockState.is(Blocks.GRAVEL)) {
            return OperationStarcleaveBlocks.STARDUST_BLOCK.defaultBlockState();
        }
        if (blockState.is(BlockTags.LEAVES) || blockState.is(BlockTags.WART_BLOCKS) || blockState.is(Blocks.CHORUS_PLANT) || blockState.is(Blocks.CHORUS_FLOWER)) {
            if (random.nextInt(3) == 0) {
                return OperationStarcleaveBlocks.STARBLEACHED_LEAVES.defaultBlockState();
            }
            return Blocks.AIR.defaultBlockState();
        }
        if (blockState.is(BlockTags.LOGS)) {
            if (blockState.getProperties().contains(RotatedPillarBlock.AXIS)) {
                return (BlockState)OperationStarcleaveBlocks.STARBLEACHED_LOG.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)blockState.getValue((Property)RotatedPillarBlock.AXIS)));
            }
            return OperationStarcleaveBlocks.STARBLEACHED_LOG.defaultBlockState();
        }
        if (blockState.is(Blocks.FARMLAND)) {
            Firmament firmament = Firmament.fromLevel(world);
            if (firmament != null && StellarFarmlandBlock.isStarlit((LevelReader)world, blockPos, firmament)) {
                return (BlockState)OperationStarcleaveBlocks.STELLAR_FARMLAND.defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(7));
            }
            return OperationStarcleaveBlocks.STELLAR_FARMLAND.defaultBlockState();
        }
        return null;
    }

    public static enum StarbleachTarget {
        ALL,
        ONLY_FILLING,
        NO_FILLING;

    }
}

