/*
 * Decompiled with CFR 0.152.
 */
package com.iceyetiwins.universalPlayerData.mixin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_29;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_29.class})
public class PlayerSaveHandlerMixin {
    private static final Path UNIVERSAL_PLAYER_DATA_DIR = FabricLoader.getInstance().getGameDir().resolve("universal-playerdata");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"universalPlayerData");
    @Final
    @Shadow
    private File field_144;

    @Inject(method={"savePlayerData"}, at={@At(value="TAIL")})
    private void onSavePlayerData(class_1657 player, CallbackInfo ci) {
        try {
            Files.createDirectories(UNIVERSAL_PLAYER_DATA_DIR, new FileAttribute[0]);
            File worldPlayerData = new File(this.field_144, player.method_5845() + ".dat");
            File worldPlayerDataBackup = new File(this.field_144, player.method_5845() + ".dat_old");
            File universalPlayerData = new File(UNIVERSAL_PLAYER_DATA_DIR.toFile(), player.method_5845() + ".dat");
            File universalPlayerDataBackup = new File(UNIVERSAL_PLAYER_DATA_DIR.toFile(), player.method_5845() + ".dat_old");
            if (worldPlayerData.exists() && worldPlayerData.isFile()) {
                Files.copy(worldPlayerData.toPath(), universalPlayerData.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            if (worldPlayerDataBackup.exists() && worldPlayerDataBackup.isFile()) {
                Files.copy(worldPlayerData.toPath(), universalPlayerDataBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to save universal player data for {}", (Object)player.method_5477().getString(), (Object)e);
        }
    }

    @Inject(method={"loadPlayerData"}, at={@At(value="HEAD")}, cancellable=true)
    private void loadPlayerData(class_1657 player, String extension, CallbackInfoReturnable<Optional<class_2487>> cir) {
        File worldPlayerData = new File(this.field_144, player.method_5845() + extension);
        File universalPlayerData = new File(UNIVERSAL_PLAYER_DATA_DIR.toFile(), player.method_5845() + extension);
        if (worldPlayerData.exists() && worldPlayerData.isFile() && universalPlayerData.exists() && universalPlayerData.isFile()) {
            try {
                class_2487 worldNbt = class_2507.method_30613((Path)worldPlayerData.toPath(), (class_2505)class_2505.method_53898());
                class_2487 universalNbt = class_2507.method_30613((Path)universalPlayerData.toPath(), (class_2505)class_2505.method_53898());
                if (worldNbt.method_10545("Abilities")) {
                    universalNbt.method_10551("Abilities");
                    universalNbt.method_10566("Abilities", (class_2520)worldNbt.method_10562("Abilities"));
                } else {
                    universalNbt.method_10551("Abilities");
                }
                if (worldNbt.method_10545("LastDeathLocation")) {
                    universalNbt.method_10566("LastDeathLocation", (class_2520)worldNbt.method_10562("LastDeathLocation"));
                } else {
                    universalNbt.method_10551("LastDeathLocation");
                }
                if (worldNbt.method_10545("SpawnX") && worldNbt.method_10545("SpawnY") && worldNbt.method_10545("SpawnZ")) {
                    universalNbt.method_10569("SpawnX", worldNbt.method_10550("SpawnX"));
                    universalNbt.method_10569("SpawnY", worldNbt.method_10550("SpawnY"));
                    universalNbt.method_10569("SpawnZ", worldNbt.method_10550("SpawnZ"));
                } else {
                    universalNbt.method_10551("SpawnX");
                    universalNbt.method_10551("SpawnY");
                    universalNbt.method_10551("SpawnZ");
                }
                if (worldNbt.method_10545("playerGameType")) {
                    universalNbt.method_10551("playerGameType");
                    universalNbt.method_10566("playerGameType", (class_2520)worldNbt.method_10562("playerGameType"));
                } else {
                    universalNbt.method_10551("playerGameType");
                }
                if (worldNbt.method_10545("warden_spawn_tracker")) {
                    universalNbt.method_10566("warden_spawn_tracker", (class_2520)worldNbt.method_10562("warden_spawn_tracker"));
                } else {
                    universalNbt.method_10551("warden_spawn_tracker");
                }
                class_2507.method_30614((class_2487)universalNbt, (Path)universalPlayerData.toPath());
                cir.setReturnValue(Optional.of(universalNbt));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to load or modify player data for {}", (Object)player.method_5477().getString(), (Object)e);
            }
        } else if (universalPlayerData.exists() && universalPlayerData.isFile()) {
            try {
                class_2487 universalNbt = class_2507.method_30613((Path)universalPlayerData.toPath(), (class_2505)class_2505.method_53898());
                universalNbt.method_10551("Abilities");
                universalNbt.method_10551("LastDeathLocation");
                universalNbt.method_10551("SpawnX");
                universalNbt.method_10551("SpawnY");
                universalNbt.method_10551("SpawnZ");
                universalNbt.method_10551("playerGameType");
                universalNbt.method_10551("warden_spawn_tracker");
                cir.setReturnValue(Optional.of(universalNbt));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to load or modify player data for {}", (Object)player.method_5477().getString(), (Object)e);
            }
        }
    }
}

