/*
 * Decompiled with CFR 0.152.
 */
package com.example.lavadetector;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static int closestLavaDistance = -1;
    private static final int DETECTION_RADIUS = 20;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ClientEvents.checkLavaDistance(Minecraft.m_91087_());
        }
    }

    private static void checkLavaDistance(Minecraft mc) {
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        ClientLevel level = mc.f_91073_;
        BlockPos playerPos = mc.f_91074_.m_20183_();
        int minDistance = 21;
        for (int x = -20; x <= 20; ++x) {
            for (int y = -20; y <= 20; ++y) {
                for (int z = -20; z <= 20; ++z) {
                    int distance;
                    BlockPos checkPos = playerPos.m_7918_(x, y, z);
                    if (!level.m_8055_(checkPos).m_60713_(Blocks.f_49991_) || (distance = (int)Math.sqrt(playerPos.m_123331_((Vec3i)checkPos))) >= minDistance) continue;
                    minDistance = distance;
                }
            }
        }
        closestLavaDistance = minDistance <= 20 ? minDistance : -1;
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        if (closestLavaDistance == -1) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        PoseStack stack = event.getPoseStack();
        String text = "LAVA: " + closestLavaDistance + " blocks away!";
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        int textWidth = mc.f_91062_.m_92895_(text);
        int x = (width - textWidth) / 2;
        int y = height - 60;
        int color = closestLavaDistance <= 5 ? -65536 : -256;
        mc.f_91062_.m_92750_(stack, text, (float)x, (float)y, color);
    }
}

