/*
 * Decompiled with CFR 0.152.
 */
package me.imbanana.renderer;

import java.awt.Color;
import java.util.SequencedCollection;
import me.imbanana.BetterFishing;
import me.imbanana.ModConfig;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class FishingLineRenderer {
    public static int segmentIndex = 0;
    public static float animationProgress = 0.0f;

    public static int renderFishingLineColor() {
        ModConfig config = BetterFishing.getConfig();
        float pos = (float)segmentIndex / (float)FishingLineRenderer.getSegmentCount();
        float animationSpeed = config.shouldAnimateFishingLineColor() ? config.getFishingLineAnimationSpeed() : 0.0f;
        float dir = config.shouldReverseAnimationDirection() ? -1.0f : 1.0f;
        float delta = (pos + (animationProgress = FishingLineRenderer.wrapOnce(animationProgress + class_310.method_1551().method_61966().method_60638() * animationSpeed * 0.015f * dir, 1.0f))) % 1.0f;
        if (delta < 0.0f) {
            delta += 1.0f;
        }
        float smoothDelta = (0.5f - Math.abs(delta - 0.5f)) * 2.0f;
        smoothDelta = smoothDelta * smoothDelta * (3.0f - 2.0f * smoothDelta);
        float finalDelta = config.shouldAnimateFishingLineColor() ? smoothDelta : pos;
        int colorIdx = FishingLineRenderer.segmentPosToColorIdx(finalDelta);
        SequencedCollection colorList = config.getFishingLineColors().reversed();
        return FishingLineRenderer.lerpColor(finalDelta, ((Color)colorList.get(colorIdx)).getRGB(), ((Color)colorList.get(colorIdx + 1 >= colorList.size() ? (config.shouldAnimateFishingLineColor() ? 0 : colorIdx) : colorIdx + 1)).getRGB());
    }

    private static int lerpColor(float delta, int start, int end) {
        int startAlpha = start >> 24 & 0xFF;
        int startR = start >> 16 & 0xFF;
        int startG = start >> 8 & 0xFF;
        int startB = start & 0xFF;
        int endAlpha = end >> 24 & 0xFF;
        int endR = end >> 16 & 0xFF;
        int endG = end >> 8 & 0xFF;
        int endB = end & 0xFF;
        int finalAlpha = class_3532.method_48781((float)delta, (int)startAlpha, (int)endAlpha);
        int finalR = class_3532.method_48781((float)delta, (int)startR, (int)endR);
        int finalG = class_3532.method_48781((float)delta, (int)startG, (int)endG);
        int finalB = class_3532.method_48781((float)delta, (int)startB, (int)endB);
        return finalAlpha << 24 | finalR << 16 | finalG << 8 | finalB;
    }

    private static float wrapOnce(float a, float b) {
        return a > b ? a - b : a;
    }

    private static int segmentPosToColorIdx(float pos) {
        return (int)(pos * (float)(BetterFishing.getConfig().getFishingLineColors().size() - 1));
    }

    public static int getSegmentCount() {
        return 16;
    }

    public static void setSegmentIndex(float segmentStart) {
        segmentIndex = FishingLineRenderer.getSegmentIdx(segmentStart);
    }

    private static int getSegmentIdx(float x) {
        return Math.round(x * (float)FishingLineRenderer.getSegmentCount());
    }
}

