/*
 * Decompiled with CFR 0.152.
 */
package me.imbanana;

import com.google.gson.GsonBuilder;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import me.imbanana.BetterFishing;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;

public class ModConfig
implements ModMenuApi {
    public static ConfigClassHandler<ModConfig> HANDLER = ConfigClassHandler.createBuilder(ModConfig.class).id(BetterFishing.idOf("config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(FabricLoader.getInstance().getConfigDir().resolve("betterfishing.json5")).appendGsonBuilder(GsonBuilder::setPrettyPrinting).setJson5(true).build()).build();
    @SerialEntry
    private boolean makeSoundWhenCaughtAFish = true;
    @SerialEntry
    private boolean openWaterDetection = false;
    @SerialEntry
    private boolean autoFishingEnabled = false;
    @SerialEntry
    private int recastDelay = 20;
    @SerialEntry
    private int reelDelay = 10;
    @SerialEntry
    private boolean showRecastTime = true;
    @SerialEntry
    private boolean breakProtection = true;
    @SerialEntry
    private boolean fishingLineColorEnabled = false;
    @SerialEntry
    private boolean animateFishingLineColor = false;
    @SerialEntry
    private float fishingLineAnimationSpeed = 1.0f;
    @SerialEntry
    private boolean reverseAnimationDirection = false;
    @SerialEntry
    private List<Color> fishingLineColors = new ArrayList<Color>(){
        {
            this.add(Color.BLACK);
        }
    };

    public boolean shouldMakeSoundWhenCaughtAFish() {
        return this.makeSoundWhenCaughtAFish;
    }

    public boolean isOpenWaterDetection() {
        return this.openWaterDetection;
    }

    public boolean isAutoFishingEnabled() {
        return this.autoFishingEnabled;
    }

    public int getRecastDelay() {
        return this.recastDelay;
    }

    public int getReelDelay() {
        return this.reelDelay;
    }

    public boolean shouldShowRecastTime() {
        return this.showRecastTime;
    }

    public boolean getBreakProtection() {
        return this.breakProtection;
    }

    public boolean isFishingLineColorEnabled() {
        return this.fishingLineColorEnabled;
    }

    public boolean shouldAnimateFishingLineColor() {
        return this.animateFishingLineColor;
    }

    public float getFishingLineAnimationSpeed() {
        return this.fishingLineAnimationSpeed;
    }

    public boolean shouldReverseAnimationDirection() {
        return this.reverseAnimationDirection;
    }

    public List<Color> getFishingLineColors() {
        return this.fishingLineColors;
    }

    public void toggleAutoFishing() {
        this.autoFishingEnabled = !this.autoFishingEnabled;
        HANDLER.save();
    }

    public void disableAutoFishing() {
        this.autoFishingEnabled = false;
        HANDLER.save();
    }

    public YetAnotherConfigLib.Builder createConfigScreen(ModConfig defaults, ModConfig config, YetAnotherConfigLib.Builder builder) {
        Option makeSoundWhenCaughtAFishOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.betterfishing.option.make_sound_when_caught_a_fish")).binding((Object)defaults.shouldMakeSoundWhenCaughtAFish(), config::shouldMakeSoundWhenCaughtAFish, value -> {
            config.makeSoundWhenCaughtAFish = value;
        }).controller(TickBoxControllerBuilder::create).build();
        Option openWaterDetectionOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.betterfishing.option.open_water_detection")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.betterfishing.option.open_water_detection.desc")})).binding((Object)defaults.isOpenWaterDetection(), config::isOpenWaterDetection, value -> {
            config.openWaterDetection = value;
        }).controller(TickBoxControllerBuilder::create).build();
        Option recastDelayOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.betterfishing.option.auto_fishing.recast_delay")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.betterfishing.option.auto_fishing.recast_delay.desc")})).binding((Object)defaults.getRecastDelay(), config::getRecastDelay, value -> {
            config.recastDelay = value;
        }).controller(option -> ((IntegerFieldControllerBuilder)IntegerFieldControllerBuilder.create((Option)option).min((Number)0)).formatValue(v -> class_2561.method_43470((String)String.format("%s ticks", v)))).available(config.isAutoFishingEnabled()).build();
        Option reelDelayOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.betterfishing.option.auto_fishing.reel_delay")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.betterfishing.option.auto_fishing.reel_delay.desc")})).binding((Object)defaults.getReelDelay(), config::getReelDelay, value -> {
            config.reelDelay = value;
        }).controller(option -> ((IntegerFieldControllerBuilder)IntegerFieldControllerBuilder.create((Option)option).min((Number)0)).formatValue(v -> class_2561.method_43470((String)String.format("%s ticks", v)))).available(config.isAutoFishingEnabled()).build();
        Option showRecastTimeOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.betterfishing.option.auto_fishing.show_recast_time")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.betterfishing.option.auto_fishing.show_recast_time.desc")})).binding((Object)defaults.shouldShowRecastTime(), config::shouldShowRecastTime, value -> {
            config.showRecastTime = value;
        }).controller(TickBoxControllerBuilder::create).available(config.isAutoFishingEnabled()).build();
        Option breakProtectionOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.betterfishing.option.auto_fishing.break_protection")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.betterfishing.option.auto_fishing.break_protection.desc")})).binding((Object)defaults.getBreakProtection(), config::getBreakProtection, value -> {
            config.breakProtection = value;
        }).controller(TickBoxControllerBuilder::create).available(config.isAutoFishingEnabled()).build();
        Option autoFishingEnabledOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.betterfishing.option.auto_fishing.enable")).binding((Object)defaults.isAutoFishingEnabled(), config::isAutoFishingEnabled, value -> {
            config.autoFishingEnabled = value;
        }).controller(TickBoxControllerBuilder::create).addListener((option, event) -> {
            boolean value = (Boolean)option.pendingValue();
            recastDelayOption.setAvailable(value);
            reelDelayOption.setAvailable(value);
            showRecastTimeOption.setAvailable(value);
            breakProtectionOption.setAvailable(value);
        }).build();
        Option fishingLineAnimationSpeedOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.betterfishing.option.fishing_line.animation_speed")).binding((Object)Float.valueOf(defaults.getFishingLineAnimationSpeed()), config::getFishingLineAnimationSpeed, value -> {
            config.fishingLineAnimationSpeed = value.floatValue();
        }).controller(option -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)option).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f))).formatValue(value -> class_2561.method_43470((String)(String.format("%.1f", Float.valueOf(value.floatValue() * 100.0f)) + "%")))).step((Number)Float.valueOf(0.001f))).available(config.isFishingLineColorEnabled() && config.shouldAnimateFishingLineColor()).build();
        Option reverseAnimationDirectionOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.betterfishing.option.fishing_line.reverse")).binding((Object)defaults.shouldReverseAnimationDirection(), config::shouldReverseAnimationDirection, value -> {
            config.reverseAnimationDirection = value;
        }).controller(TickBoxControllerBuilder::create).available(config.isFishingLineColorEnabled() && config.shouldAnimateFishingLineColor()).build();
        Option animateFishingLineColorOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.betterfishing.option.fishing_line.animate")).binding((Object)defaults.shouldAnimateFishingLineColor(), config::shouldAnimateFishingLineColor, value -> {
            config.animateFishingLineColor = value;
        }).controller(TickBoxControllerBuilder::create).addListener((option, event) -> {
            fishingLineAnimationSpeedOption.setAvailable(((Boolean)option.pendingValue()).booleanValue());
            reverseAnimationDirectionOption.setAvailable(((Boolean)option.pendingValue()).booleanValue());
        }).available(config.isFishingLineColorEnabled()).build();
        ListOption fishingLineColorsOption = ListOption.createBuilder().name((class_2561)class_2561.method_43471((String)"config.betterfishing.option.fishing_line.colors")).binding(defaults.getFishingLineColors(), config::getFishingLineColors, value -> {
            config.fishingLineColors = value;
        }).minimumNumberOfEntries(1).maximumNumberOfEntries(16).initial((Object)Color.BLACK).controller(ColorControllerBuilder::create).available(config.isFishingLineColorEnabled()).build();
        Option fishingLineColorEnabledOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.betterfishing.option.fishing_line.enable")).binding((Object)defaults.isFishingLineColorEnabled(), config::isFishingLineColorEnabled, value -> {
            config.fishingLineColorEnabled = value;
        }).controller(TickBoxControllerBuilder::create).addListener((option, event) -> {
            animateFishingLineColorOption.setAvailable(((Boolean)option.pendingValue()).booleanValue());
            fishingLineAnimationSpeedOption.setAvailable((Boolean)option.pendingValue() != false && (Boolean)animateFishingLineColorOption.pendingValue() != false);
            reverseAnimationDirectionOption.setAvailable((Boolean)option.pendingValue() != false && (Boolean)animateFishingLineColorOption.pendingValue() != false);
            fishingLineColorsOption.setAvailable(((Boolean)option.pendingValue()).booleanValue());
        }).build();
        return builder.title((class_2561)class_2561.method_43471((String)"config.betterfishing.title")).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"config.betterfishing.category.betterfishing")).option(makeSoundWhenCaughtAFishOption).option(openWaterDetectionOption).group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"config.betterfishing.group.auto_fishing")).option(autoFishingEnabledOption).option(recastDelayOption).option(reelDelayOption).option(showRecastTimeOption).option(breakProtectionOption).build()).build()).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"config.betterfishing.group.fishing_line")).option(fishingLineColorEnabledOption).option(animateFishingLineColorOption).option(fishingLineAnimationSpeedOption).option(reverseAnimationDirectionOption).group((OptionGroup)fishingLineColorsOption).build());
    }

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return screen -> YetAnotherConfigLib.create(HANDLER, this::createConfigScreen).generateScreen(screen);
    }
}

