package pet.cyan.skobeloff.mixin;

import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import pet.cyan.skobeloff.Skobeloff;

@Mixin(class_1309.class)
public class LivingEntityMixin {
    @Inject(at = @At("HEAD"), method = "damage", cancellable = true)
    public void cloakedDamagerCheck(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (source.method_5529() instanceof class_1309 attacker) {
            Optional<TrinketComponent> tc = TrinketsApi.getTrinketComponent(attacker);
            if (tc.isPresent() && tc.get().isEquipped(Skobeloff.SALT_PENDANT) && (class_1309)(Object)this instanceof class_1308 mob) {
                class_1299<?> entityType = mob.method_5864();
                class_6862<class_1299<?>> bosses = class_6862.method_40092(class_7924.field_41266, new class_2960("c","bosses"));
                if (!entityType.method_20210(bosses) && ((MobEntityInvoker)mob).invokeIsDisallowedInPeaceful()) { // if entity isn't a boss (and is hostile), don't detect player
                    cir.setReturnValue(false); // if you can't detect the player, the player can't attack you
                }
            }
        }
    }
}
