package pet.cyan.skobeloff.mixin;

import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_4051;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import pet.cyan.skobeloff.Skobeloff;

@Mixin(class_4051.class)
public abstract class CloakingMixin {
    @Inject(at = @At("HEAD"), method = "test", cancellable = true)
    public void cloakingOverride(@Nullable class_1309 baseEntity, class_1309 targetEntity, CallbackInfoReturnable<Boolean> info) {
        Optional<TrinketComponent> tc = TrinketsApi.getTrinketComponent(targetEntity); // if a player is
        if (tc.isPresent() && tc.get().isEquipped(Skobeloff.SALT_PENDANT)) {
            if (baseEntity != null && baseEntity instanceof class_1308 mob) {
                class_1299<?> entityType = baseEntity.method_5864();
                class_6862<class_1299<?>> bosses = class_6862.method_40092(class_7924.field_41266, new class_2960("c","bosses"));
                if (!entityType.method_20210(bosses) && ((MobEntityInvoker)mob).invokeIsDisallowedInPeaceful()) { // if entity isn't a boss (and is hostile), don't detect player
                    info.setReturnValue(false);
                }
            } else { // if no entity, don't detect player (?)
                info.setReturnValue(false);
            }
        }
    }
}
