/*
 * Decompiled with CFR 0.152.
 */
package com.voxelforge.homesteads.init;

import com.google.common.collect.ImmutableSet;
import com.voxelforge.homesteads.HomesteadsMod;
import com.voxelforge.homesteads.init.HomesteadsModBlocks;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class HomesteadsModVillagerProfessions {
    private static final Map<String, ProfessionPoiType> POI_TYPES = new HashMap<String, ProfessionPoiType>();
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((ResourceKey)Registries.VILLAGER_PROFESSION, (String)"homesteads");
    public static final DeferredHolder<VillagerProfession, VillagerProfession> HOME_STEADER = HomesteadsModVillagerProfessions.registerProfession("home_steader", () -> (Block)HomesteadsModBlocks.TANNING_RACK.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"block.wool.hit")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> BEE_KEEPER = HomesteadsModVillagerProfessions.registerProfession("bee_keeper", () -> (Block)HomesteadsModBlocks.HONEY_BOTTLING_STATION.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"block.honey_block.place")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> LUMBER_JACK = HomesteadsModVillagerProfessions.registerProfession("lumber_jack", () -> (Block)HomesteadsModBlocks.WOOD_WORK_LOG.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"block.wood.break")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> PROSPECTOR = HomesteadsModVillagerProfessions.registerProfession("prospector", () -> (Block)HomesteadsModBlocks.PROSPECTORS_BENCH.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"block.stone.break")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> FORAGER = HomesteadsModVillagerProfessions.registerProfession("forager", () -> (Block)HomesteadsModBlocks.FORAGER_BENCH.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"block.flowering_azalea.step")));

    private static DeferredHolder<VillagerProfession, VillagerProfession> registerProfession(String name, Supplier<Block> block, Supplier<SoundEvent> soundEvent) {
        POI_TYPES.put(name, new ProfessionPoiType(block, null));
        return PROFESSIONS.register(name, () -> {
            Predicate<Holder> poiPredicate = poiTypeHolder -> HomesteadsModVillagerProfessions.POI_TYPES.get((Object)name).poiType != null && poiTypeHolder.value() == HomesteadsModVillagerProfessions.POI_TYPES.get((Object)name).poiType.value();
            return new VillagerProfession((Component)Component.translatable((String)("entity.minecraft.villager.homesteads." + name)), poiPredicate, poiPredicate, ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)soundEvent.get());
        });
    }

    @SubscribeEvent
    public static void registerProfessionPointsOfInterest(RegisterEvent event) {
        event.register(Registries.POINT_OF_INTEREST_TYPE, registerHelper -> {
            for (Map.Entry<String, ProfessionPoiType> entry : POI_TYPES.entrySet()) {
                Block block = entry.getValue().block.get();
                String name = entry.getKey();
                Optional existingCheck = PoiTypes.forState((BlockState)block.defaultBlockState());
                if (existingCheck.isPresent()) {
                    HomesteadsMod.LOGGER.error("Skipping villager profession " + name + " that uses POI block " + String.valueOf(block) + " that is already in use by " + String.valueOf(existingCheck));
                    continue;
                }
                PoiType poiType = new PoiType((Set)ImmutableSet.copyOf((Collection)block.getStateDefinition().getPossibleStates()), 1, 1);
                registerHelper.register(ResourceLocation.fromNamespaceAndPath((String)"homesteads", (String)name), (Object)poiType);
                entry.getValue().poiType = BuiltInRegistries.POINT_OF_INTEREST_TYPE.wrapAsHolder((Object)poiType);
            }
        });
    }

    private static class ProfessionPoiType {
        final Supplier<Block> block;
        Holder<PoiType> poiType;

        ProfessionPoiType(Supplier<Block> block, Holder<PoiType> poiType) {
            this.block = block;
            this.poiType = poiType;
        }
    }
}

