/*
 * Decompiled with CFR 0.152.
 */
package com.voxelforge;

import com.google.common.collect.ImmutableSet;
import com.voxelforge.Homesteads;
import com.voxelforge.ModBlocks;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3852;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ModVillagerProfessions {
    public static class_4158 TANNING_RACK_POI;
    public static class_4158 HONEY_BOTTLING_STATION_POI;
    public static class_4158 WOOD_WORK_LOG_POI;
    public static class_4158 PROSPECTORS_BENCH_POI;
    public static class_4158 FORAGER_BENCH_POI;
    public static class_3852 HOME_STEADER;
    public static class_3852 BEE_KEEPER;
    public static class_3852 LUMBER_JACK;
    public static class_3852 PROSPECTOR;
    public static class_3852 FORAGER;

    private static class_4158 registerPoi(String name, class_2248 block) {
        Homesteads.LOGGER.info("Registering POI: {} with block: {}", (Object)name, (Object)class_7923.field_41175.method_10221((Object)block));
        class_4158 poi = PointOfInterestHelper.register((class_2960)class_2960.method_60655((String)"homesteads", (String)name), (int)1, (int)1, (class_2248[])new class_2248[]{block});
        return poi;
    }

    private static class_3852 registerProfession(String name, String poiName, class_4158 poiType, Supplier<class_3414> soundEvent) {
        Homesteads.LOGGER.info("Registering profession: {} with POI: {}", (Object)name, (Object)poiName);
        class_5321 poiKey = class_5321.method_29179((class_5321)class_7924.field_41212, (class_2960)class_2960.method_60655((String)"homesteads", (String)poiName));
        Predicate<class_6880> heldWorkstation = entry -> {
            boolean matches = entry.method_40225(poiKey);
            if (matches) {
                // empty if block
            }
            return matches;
        };
        Predicate<class_6880> acquirableWorkstation = entry -> entry.method_40225(poiKey);
        class_3852 profession = new class_3852((class_2561)class_2561.method_43471((String)("entity.minecraft.villager.homesteads." + name)), heldWorkstation, acquirableWorkstation, ImmutableSet.of(), ImmutableSet.of(), soundEvent.get());
        class_3852 registered = (class_3852)class_2378.method_10230((class_2378)class_7923.field_41195, (class_2960)class_2960.method_60655((String)"homesteads", (String)name), (Object)profession);
        return registered;
    }

    public static void initialize() {
        TANNING_RACK_POI = ModVillagerProfessions.registerPoi("tanning_rack_poi", ModBlocks.TANNING_RACK);
        HONEY_BOTTLING_STATION_POI = ModVillagerProfessions.registerPoi("honey_bottling_station_poi", ModBlocks.BOTTELING_STATION);
        WOOD_WORK_LOG_POI = ModVillagerProfessions.registerPoi("wood_work_log_poi", ModBlocks.WOOD_WORK_LOG);
        PROSPECTORS_BENCH_POI = ModVillagerProfessions.registerPoi("prospectors_bench_poi", ModBlocks.PROSPECTORS_BENCH);
        FORAGER_BENCH_POI = ModVillagerProfessions.registerPoi("forager_bench_poi", ModBlocks.FORAGER_BENCH);
        Homesteads.LOGGER.info("=== Registering villager professions ===");
        HOME_STEADER = ModVillagerProfessions.registerProfession("home_steader", "tanning_rack_poi", TANNING_RACK_POI, () -> (class_3414)class_7923.field_41172.method_63535(class_2960.method_60655((String)"minecraft", (String)"block.wool.hit")));
        BEE_KEEPER = ModVillagerProfessions.registerProfession("bee_keeper", "honey_bottling_station_poi", HONEY_BOTTLING_STATION_POI, () -> (class_3414)class_7923.field_41172.method_63535(class_2960.method_60655((String)"minecraft", (String)"block.honey_block.place")));
        LUMBER_JACK = ModVillagerProfessions.registerProfession("lumber_jack", "wood_work_log_poi", WOOD_WORK_LOG_POI, () -> (class_3414)class_7923.field_41172.method_63535(class_2960.method_60655((String)"minecraft", (String)"block.wood.break")));
        PROSPECTOR = ModVillagerProfessions.registerProfession("prospector", "prospectors_bench_poi", PROSPECTORS_BENCH_POI, () -> (class_3414)class_7923.field_41172.method_63535(class_2960.method_60655((String)"minecraft", (String)"block.stone.break")));
        FORAGER = ModVillagerProfessions.registerProfession("forager", "forager_bench_poi", FORAGER_BENCH_POI, () -> (class_3414)class_7923.field_41172.method_63535(class_2960.method_60655((String)"minecraft", (String)"block.flowering_azalea.step")));
        class_7923.field_41128.method_29722().forEach(entry -> {
            if (((class_5321)entry.getKey()).method_29177().method_12836().equals("homesteads")) {
                Homesteads.LOGGER.info("POI: {} -> {}", (Object)((class_5321)entry.getKey()).method_29177(), entry.getValue());
            }
        });
        class_7923.field_41195.method_29722().forEach(entry -> {
            if (((class_5321)entry.getKey()).method_29177().method_12836().equals("homesteads")) {
                Homesteads.LOGGER.info("Profession: {} -> {}", (Object)((class_5321)entry.getKey()).method_29177(), entry.getValue());
            }
        });
    }
}

