/*
 * Decompiled with CFR 0.152.
 */
package com.rld.unlimitedlogistics.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.rld.unlimitedlogistics.CreateUnlimitedLogistics;
import com.rld.unlimitedlogistics.mixin.FilteringBehaviourMixin;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FactoryPanelBehaviour.class})
public abstract class FactoryGaugeMixin
extends FilteringBehaviourMixin {
    @Unique
    int mode = 0;

    @Unique
    private int getVaultMultiplier() {
        return (Integer)AllConfigs.server().logistics.vaultCapacity.get();
    }

    @Inject(method={"createBoard"}, at={@At(value="HEAD")}, cancellable=true)
    public void onCreateBoard(Player player, BlockHitResult hitResult, CallbackInfoReturnable<ValueSettingsBoard> cir) {
        int maxAmount = 100;
        cir.setReturnValue((Object)new ValueSettingsBoard((Component)CreateLang.translate((String)"factory_panel.target_amount", (Object[])new Object[0]).component(), maxAmount, 10, List.of(CreateLang.translate((String)"schedule.condition.threshold.items", (Object[])new Object[0]).component(), CreateLang.translate((String)"schedule.condition.threshold.stacks", (Object[])new Object[0]).component(), Component.translatable((String)"schedule.condition.threshold.vaults")), new ValueSettingsFormatter(settings -> {
            if (settings.value() == 0) {
                return CreateLang.translateDirect((String)"gui.factory_panel.inactive", (Object[])new Object[0]);
            }
            int valueToShow = Math.max(0, settings.value());
            return switch (settings.row()) {
                case 1 -> Component.literal((String)(valueToShow + "\u25a4"));
                case 2 -> Component.literal((String)(valueToShow + "\u25a8"));
                default -> Component.literal((String)("" + valueToShow));
            };
        })));
        cir.cancel();
    }

    @Inject(method={"setValueSettings"}, at={@At(value="INVOKE", target="Lorg/joml/Math;max(II)I")})
    public void onSetValueSettings(Player player, ValueSettingsBehaviour.ValueSettings settings, boolean ctrlDown, CallbackInfo ci) {
        this.mode = settings.row();
        CreateUnlimitedLogistics.LOGGER.info("Row {} Value {} Mode {}", new Object[]{settings.row(), settings.value(), this.mode});
    }

    @Inject(method={"write"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;putInt(Ljava/lang/String;I)V", ordinal=0)})
    public void onWrite(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci, @Local(name={"panelTag"}) CompoundTag panelTag) {
        panelTag.putInt("Mode", this.mode);
    }

    @Inject(method={"writeSafe"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;putInt(Ljava/lang/String;I)V", ordinal=0)})
    public void onWriteSafe(CompoundTag nbt, HolderLookup.Provider registries, CallbackInfo ci, @Local(name={"panelTag"}) CompoundTag panelTag) {
        panelTag.putInt("Mode", this.mode);
    }

    @Inject(method={"read"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/filter/FilterItemStack;of(Lnet/minecraft/core/HolderLookup$Provider;Lnet/minecraft/nbt/CompoundTag;)Lcom/simibubi/create/content/logistics/filter/FilterItemStack;", ordinal=0)})
    public void onRead(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci, @Local(name={"panelTag"}) CompoundTag panelTag) {
        this.mode = panelTag.getInt("Mode");
    }

    @Overwrite
    public ValueSettingsBehaviour.ValueSettings getValueSettings() {
        return new ValueSettingsBehaviour.ValueSettings(this.mode, this.count);
    }

    @ModifyVariable(method={"getCountLabelForValueBox"}, at=@At(value="STORE"), name={"inStorage"})
    public int modifyInStorage(int is, @Local(name={"levelInStorage"}) int levelInStorage) {
        return levelInStorage / (switch (this.mode) {
            case 0 -> 1;
            case 1 -> this.getFilter().getMaxStackSize();
            case 2 -> this.getFilter().getMaxStackSize() * this.getVaultMultiplier();
            default -> throw new IllegalStateException("Invalid Mode: " + this.mode);
        });
    }

    @ModifyVariable(method={"getCountLabelForValueBox"}, at=@At(value="STORE"), name={"stacks"})
    public String modifyStacks(String stacks) {
        return switch (this.mode) {
            case 0 -> "";
            case 1 -> "\u25a4";
            case 2 -> "\u25a8";
            default -> throw new IllegalArgumentException("Mode is outside bounds [0,2]");
        };
    }

    @ModifyVariable(method={"tickStorageMonitor"}, at=@At(value="STORE"), name={"demand"})
    public int modifyDemand(int original) {
        int n = this.getAmount();
        return n * (switch (this.mode) {
            case 0 -> 1;
            case 1 -> this.getFilter().getMaxStackSize();
            case 2 -> this.getFilter().getMaxStackSize() * this.getVaultMultiplier();
            default -> throw new IllegalArgumentException("Invalid Mode");
        });
    }
}

