# Evol's 3D Bars for Minecraft 1.21.9

A Minecraft resource pack that brings iron bars and all copper bar variants to life with high-quality 3D models and detailed 32x32 textures. Designed to enhance realism and immersion, this pack also includes full PBR (Physically Based Rendering) support for use with popular shaders.

## Features

- **3D Models**: Replaces the default flat plane models of iron and copper bars with detailed 3D models.

- **High-Resolution Textures**: All new 32x32 textures for a sharper and more detailed look.

- **Full Copper Family**: Includes models and textures for all variants:
  
  - Copper Bars
  
  - Exposed Copper Bars
  
  - Weathered Copper Bars
  
  - Oxidized Copper Bars
  
  - All Waxed versions of the above

- **PBR Support**: Includes normal and specular maps for incredible lighting and surface effects when using shaders like BSL, Complementary, SEUS, and more.

- **Vanilla Friendly**: Looks great even without shaders, providing a noticeable upgrade to the vanilla experience.

## Installation

1. Download the latest release of `Evol's_3D_Bars.zip` from the project page.

2. Launch Minecraft.

3. On the main menu, click **Options...** then **Resource Packs...**

4. Click the **Open Pack Folder** button. This will open the `resourcepacks` folder.

5. Drag and drop the downloaded `.zip` file into the `resourcepacks` folder.

6. Go back to Minecraft, and you should see "Evol's 3D Bars" in the list of available packs. Click the arrow to move it to the "Selected" column.

7. Click **Done** and enjoy your new 3D bars!

### How to Enable PBR Textures (for Shaders)

To take full advantage of the PBR textures, you will need:

1. **OptiFine** or **Iris Shaders**.

2. A shader pack that supports PBR materials (e.g., BSL, Complementary Shaders, Rethinking Voxels, SEUS PTGI).

Once you have a shader active, ensure that the PBR material or "LabPBR" format is enabled in the shader settings for the best visual results.

## Credits

All models and textures were created by **Evol**.

## License

This resource pack is licensed under the Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License. To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-nd/4.0/.

---

## CHANGELOG

### v1.0.0 - (October 6, 2025)

- **Initial Release**
  
  - Added 3D models for Iron Bars.
  
  - Added 3D models for Copper Bars, Exposed Copper Bars, Weathered Copper Bars, Oxidized Copper Bars, and all waxed variants.
  
  - Created all-new 32x32 textures for all included bars.
  
  - Added full PBR support (normal and specular maps) for all textures.
  
  - Pack formatted for Minecraft version `1.21.9`.

### v1.0.2 - (October 16, 2025)

##### - Simple Corrections

    - Fixed the mcpack "pack_format" to the new standard and added the appropriate "min_format" "max_format" labels.
