/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.BanFromClaim;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.File;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import no.vestlandetmc.BanFromClaim.apiversions.VersionManager;
import no.vestlandetmc.BanFromClaim.bstats.bukkit.Metrics;
import no.vestlandetmc.BanFromClaim.commands.BfcAllCommand;
import no.vestlandetmc.BanFromClaim.commands.BfcCommand;
import no.vestlandetmc.BanFromClaim.commands.BfclistCommand;
import no.vestlandetmc.BanFromClaim.commands.KfcCommand;
import no.vestlandetmc.BanFromClaim.commands.SafeSpot;
import no.vestlandetmc.BanFromClaim.commands.UnbfcCommand;
import no.vestlandetmc.BanFromClaim.config.ClaimData;
import no.vestlandetmc.BanFromClaim.config.Config;
import no.vestlandetmc.BanFromClaim.config.Messages;
import no.vestlandetmc.BanFromClaim.handler.MessageHandler;
import no.vestlandetmc.BanFromClaim.handler.Permissions;
import no.vestlandetmc.BanFromClaim.hooks.HookManager;
import no.vestlandetmc.BanFromClaim.listener.CombatMode;
import no.vestlandetmc.BanFromClaim.listener.PlayerListener;
import no.vestlandetmc.BanFromClaim.listener.RegionListener;
import no.vestlandetmc.BanFromClaim.schedulers.CombatScheduler;
import no.vestlandetmc.BanFromClaim.utils.UpdateNotification;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BfcPlugin
extends JavaPlugin {
    private static BfcPlugin plugin;
    private static HookManager hookManager;
    private static VersionManager versionManager;
    private static FileConfiguration dataFile;

    public void onEnable() {
        plugin = this;
        MessageHandler.sendConsole("&2 ___ ___ ___");
        MessageHandler.sendConsole("&2| _ ) __/ __|        &8" + this.getPluginMeta().getName() + " v" + this.getPluginMeta().getVersion());
        MessageHandler.sendConsole("&2| _ \\ _| (__         &8Author: " + this.getPluginMeta().getAuthors().toString().replace("[", "").replace("]", ""));
        MessageHandler.sendConsole("&2|___/_| \\___|");
        MessageHandler.sendConsole("");
        Config.initialize();
        Permissions.register();
        versionManager = new VersionManager();
        hookManager = new HookManager();
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> {
            ((Commands)commands.registrar()).register("banfromclaimall", "Ban all players from your claim.", List.of("bfca", "bfcall"), (BasicCommand)new BfcAllCommand());
            ((Commands)commands.registrar()).register("banfromclaim", "Ban a player from your claim.", List.of("bfc", "banfc"), (BasicCommand)new BfcCommand());
            ((Commands)commands.registrar()).register("banfromclaimlist", "Displays a list of banned players in your claim.", List.of("bfcl", "bfclist"), (BasicCommand)new BfclistCommand());
            ((Commands)commands.registrar()).register("bfcsafespot", "Set new safespot.", List.of("bfcs", "bfcsetsafe"), (BasicCommand)new SafeSpot());
            ((Commands)commands.registrar()).register("unbanfromclaim", "Unban a player from your claim.", List.of("ubfc", "unbanfc"), (BasicCommand)new UnbfcCommand());
            if (Config.KICKMODE) {
                ((Commands)commands.registrar()).register("kickfromclaim", "Kick a player from your claim.", List.of("kfc", "kickfc"), (BasicCommand)new KfcCommand());
            }
        });
        this.getServer().getPluginManager().registerEvents((Listener)new RegionListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        this.createDatafile();
        Messages.initialize();
        ClaimData.createSection();
        if (Config.COMBAT_ENABLED) {
            this.getServer().getPluginManager().registerEvents((Listener)new CombatMode(), (Plugin)this);
            new CombatScheduler().runTaskTimer((Plugin)this, 0L, 20L);
        }
        new UpdateNotification(this, "banfromclaim"){

            @Override
            public void onUpdateAvailable() {
                MessageHandler.sendConsole("&c-----------------------");
                MessageHandler.sendConsole("&2[BanFromClaim] &7Version " + 1.getLatestVersion() + " is now available!");
                MessageHandler.sendConsole("&2[BanFromClaim] &7Download the update at https://modrinth.com/plugin/" + 1.getProjectSlug());
                MessageHandler.sendConsole("&c-----------------------");
            }
        }.runTaskAsynchronously((Plugin)this);
        int pluginId = 22441;
        Metrics metrics = new Metrics((Plugin)this, 22441);
    }

    public void createDatafile() {
        File newDataFile = new File(this.getDataFolder(), "data.dat");
        if (!newDataFile.exists()) {
            newDataFile.getParentFile().mkdirs();
            try {
                newDataFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe(e.getMessage());
            }
        }
        dataFile = new YamlConfiguration();
        try {
            dataFile.load(newDataFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            this.getLogger().severe(e.getMessage());
        }
    }

    @Generated
    public static BfcPlugin getPlugin() {
        return plugin;
    }

    @Generated
    public static HookManager getHookManager() {
        return hookManager;
    }

    @Generated
    public static VersionManager getVersionManager() {
        return versionManager;
    }

    @Generated
    public static FileConfiguration getDataFile() {
        return dataFile;
    }
}

