/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.BanFromClaim.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Collection;
import no.vestlandetmc.BanFromClaim.BfcPlugin;
import no.vestlandetmc.BanFromClaim.config.ClaimData;
import no.vestlandetmc.BanFromClaim.config.Messages;
import no.vestlandetmc.BanFromClaim.handler.MessageHandler;
import no.vestlandetmc.BanFromClaim.handler.Permissions;
import no.vestlandetmc.BanFromClaim.hooks.RegionHook;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class BfcAllCommand
implements BasicCommand {
    public void execute(CommandSourceStack commandSourceStack, String[] strings) {
        boolean allowBan;
        CommandSender commandSender = commandSourceStack.getSender();
        if (!(commandSender instanceof Player)) {
            MessageHandler.sendConsole("&cThis command can only be used in-game.");
            return;
        }
        Player player = (Player)commandSender;
        ClaimData claimData = new ClaimData();
        RegionHook region = BfcPlugin.getHookManager().getActiveRegionHook();
        String regionID = region.getRegionID(player);
        if (regionID == null) {
            MessageHandler.sendMessage(player, Messages.OUTSIDE_CLAIM);
            return;
        }
        boolean bl = allowBan = player.hasPermission("bfc.admin") || region.isOwner((OfflinePlayer)player, regionID) || region.isManager((OfflinePlayer)player, regionID);
        if (allowBan) {
            claimData.banAll(regionID);
            if (claimData.isAllBanned(regionID)) {
                MessageHandler.sendMessage(player, Messages.BAN_ALL);
            } else {
                MessageHandler.sendMessage(player, Messages.UNBAN_ALL);
            }
        } else {
            MessageHandler.sendMessage(player, Messages.NO_ACCESS);
        }
    }

    public Collection<String> suggest(CommandSourceStack commandSourceStack, String[] args) {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).toList();
    }

    public boolean canUse(CommandSender sender) {
        return super.canUse(sender);
    }

    public @Nullable String permission() {
        return Permissions.BANALL.getName();
    }
}

