/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.BanFromClaim.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Collection;
import no.vestlandetmc.BanFromClaim.BfcPlugin;
import no.vestlandetmc.BanFromClaim.config.ClaimData;
import no.vestlandetmc.BanFromClaim.config.Config;
import no.vestlandetmc.BanFromClaim.config.Messages;
import no.vestlandetmc.BanFromClaim.handler.MessageHandler;
import no.vestlandetmc.BanFromClaim.handler.Permissions;
import no.vestlandetmc.BanFromClaim.hooks.RegionHook;
import no.vestlandetmc.BanFromClaim.utils.LocationFinder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class BfcCommand
implements BasicCommand {
    public void execute(CommandSourceStack commandSourceStack, String[] args) {
        boolean allowBan;
        CommandSender commandSender = commandSourceStack.getSender();
        if (!(commandSender instanceof Player)) {
            MessageHandler.sendConsole("&cThis command can only be used in-game.");
            return;
        }
        Player player = (Player)commandSender;
        RegionHook region = BfcPlugin.getHookManager().getActiveRegionHook();
        String regionID = region.getRegionID(player);
        if (args.length == 0) {
            MessageHandler.sendMessage(player, Messages.NO_ARGUMENTS);
            return;
        }
        if (regionID == null) {
            MessageHandler.sendMessage(player, Messages.OUTSIDE_CLAIM);
            return;
        }
        OfflinePlayer bannedPlayer = Bukkit.getOfflinePlayer((String)args[0]);
        boolean bl = allowBan = player.hasPermission("bfc.admin") || region.isOwner((OfflinePlayer)player, regionID) || region.isManager((OfflinePlayer)player, regionID);
        if (bannedPlayer.getUniqueId().toString().equals(player.getUniqueId().toString())) {
            MessageHandler.sendMessage(player, Messages.BAN_SELF);
            return;
        }
        if (!bannedPlayer.hasPlayedBefore()) {
            MessageHandler.sendMessage(player, Messages.placeholders(Messages.UNVALID_PLAYERNAME, args[0], player.getDisplayName(), null));
            return;
        }
        if (region.isOwner(bannedPlayer, regionID)) {
            MessageHandler.sendMessage(player, Messages.BAN_OWNER);
            return;
        }
        if (bannedPlayer.isOnline() && bannedPlayer.getPlayer().hasPermission("bfc.bypass")) {
            MessageHandler.sendMessage(player, Messages.placeholders(Messages.PROTECTED, bannedPlayer.getPlayer().getDisplayName(), null, null));
            return;
        }
        if (!allowBan) {
            MessageHandler.sendMessage(player, Messages.NO_ACCESS);
        } else {
            String claimOwner = region.getClaimOwnerName(regionID);
            int sizeRadius = region.sizeRadius(regionID);
            Location greaterCorner = region.getGreaterBoundaryCorner(regionID);
            Location lesserCorner = region.getLesserBoundaryCorner(regionID);
            if (this.setClaimData(regionID, bannedPlayer.getUniqueId().toString(), true)) {
                if (bannedPlayer.isOnline() && region.isInsideRegion(bannedPlayer.getPlayer(), regionID)) {
                    Location bannedLoc = bannedPlayer.getPlayer().getLocation();
                    LocationFinder lf = new LocationFinder(greaterCorner, lesserCorner, bannedLoc.getWorld().getUID(), sizeRadius);
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)BfcPlugin.getPlugin(), () -> lf.IterateCircumferences(randomCircumferenceRadiusLoc -> {
                        if (randomCircumferenceRadiusLoc == null) {
                            if (Config.SAFE_LOCATION == null) {
                                bannedPlayer.getPlayer().teleport(bannedLoc.getWorld().getSpawnLocation());
                            } else {
                                bannedPlayer.getPlayer().teleport(Config.SAFE_LOCATION);
                            }
                        } else {
                            bannedPlayer.getPlayer().teleport(randomCircumferenceRadiusLoc);
                        }
                        MessageHandler.sendMessage(bannedPlayer.getPlayer(), Messages.placeholders(Messages.BANNED_TARGET, bannedPlayer.getName(), player.getDisplayName(), claimOwner));
                    }));
                }
                MessageHandler.sendMessage(player, Messages.placeholders(Messages.BANNED, bannedPlayer.getName(), null, null));
            } else {
                MessageHandler.sendMessage(player, Messages.ALREADY_BANNED);
            }
        }
    }

    public Collection<String> suggest(CommandSourceStack commandSourceStack, String[] args) {
        String input = args.length > 0 ? args[args.length - 1].toLowerCase() : "";
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).sorted(String.CASE_INSENSITIVE_ORDER).toList();
    }

    public boolean canUse(CommandSender sender) {
        return super.canUse(sender);
    }

    public @Nullable String permission() {
        return Permissions.BAN.getName();
    }

    private boolean setClaimData(String claimID, String bannedUUID, boolean add) {
        ClaimData claimData = new ClaimData();
        return claimData.setClaimData(claimID, bannedUUID, add);
    }
}

