/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.BanFromClaim.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import no.vestlandetmc.BanFromClaim.BfcPlugin;
import no.vestlandetmc.BanFromClaim.config.ClaimData;
import no.vestlandetmc.BanFromClaim.config.Messages;
import no.vestlandetmc.BanFromClaim.handler.MessageHandler;
import no.vestlandetmc.BanFromClaim.handler.Permissions;
import no.vestlandetmc.BanFromClaim.hooks.RegionHook;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class BfclistCommand
implements BasicCommand {
    private int countTo = 5;
    private int countFrom = 0;
    private int number = 1;

    public void execute(CommandSourceStack commandSourceStack, String[] args) {
        boolean allowBan;
        CommandSender commandSender = commandSourceStack.getSender();
        if (!(commandSender instanceof Player)) {
            MessageHandler.sendConsole("&cThis command can only be used in-game.");
            return;
        }
        Player player = (Player)commandSender;
        ClaimData claimData = new ClaimData();
        RegionHook region = BfcPlugin.getHookManager().getActiveRegionHook();
        String regionID = region.getRegionID(player);
        if (args.length != 0) {
            if (this.isInt(args[0])) {
                this.number = Integer.parseInt(args[0]);
                this.countTo = 5 * this.number;
                this.countFrom = 5 * this.number - 5;
            } else {
                MessageHandler.sendMessage(player, Messages.UNVALID_NUMBER);
                return;
            }
        }
        if (regionID == null) {
            MessageHandler.sendMessage(player, Messages.OUTSIDE_CLAIM);
            return;
        }
        boolean bl = allowBan = player.hasPermission("bfc.admin") || region.isOwner((OfflinePlayer)player, regionID) || region.isManager((OfflinePlayer)player, regionID);
        if (!allowBan) {
            MessageHandler.sendMessage(player, Messages.NO_ACCESS);
        } else {
            MessageHandler.sendMessage(player, Messages.placeholders(Messages.LIST_HEADER, null, player.getDisplayName(), region.getClaimOwnerName(regionID)));
            if (claimData.isAllBanned(regionID)) {
                MessageHandler.sendMessage(player, Messages.LIST_BAN_ALL);
                return;
            }
            if (this.listPlayers(regionID) == null) {
                MessageHandler.sendMessage(player, Messages.placeholders(Messages.LIST_EMPTY, null, player.getDisplayName(), region.getClaimOwnerName(regionID)));
            } else {
                int totalPage = this.listPlayers(regionID).size() / 5 + 1;
                for (int i = 0; i < this.listPlayers(regionID).toArray().length; ++i) {
                    if (this.number > totalPage || this.number == 0) {
                        this.countTo = 5 * totalPage;
                        this.countFrom = 5 * totalPage - 5;
                        this.number = totalPage;
                    }
                    if (i < this.countFrom) continue;
                    String bp = (String)this.listPlayers(regionID).toArray()[i];
                    OfflinePlayer bannedPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(bp));
                    String bannedPlayerName = bannedPlayer.getName() == null ? bp : bannedPlayer.getName();
                    MessageHandler.sendMessage(player, "&6" + bannedPlayerName);
                    if (i != this.countTo) continue;
                    MessageHandler.sendMessage(player, "");
                    MessageHandler.sendMessage(player, "&e<--- [&6" + this.number + "\\" + totalPage + "&e] --->");
                    break;
                }
                if (this.number == totalPage) {
                    MessageHandler.sendMessage(player, "");
                    MessageHandler.sendMessage(player, "&e<--- [&6" + totalPage + "\\" + totalPage + "&e] --->");
                }
            }
        }
    }

    public Collection<String> suggest(CommandSourceStack commandSourceStack, String[] args) {
        return super.suggest(commandSourceStack, args);
    }

    public boolean canUse(CommandSender sender) {
        return super.canUse(sender);
    }

    public @Nullable String permission() {
        return Permissions.LIST.getName();
    }

    private List<String> listPlayers(String claimID) {
        ClaimData claimData = new ClaimData();
        return claimData.bannedPlayers(claimID);
    }

    private boolean isInt(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

