/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.BanFromClaim.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Collection;
import no.vestlandetmc.BanFromClaim.BfcPlugin;
import no.vestlandetmc.BanFromClaim.config.Config;
import no.vestlandetmc.BanFromClaim.config.Messages;
import no.vestlandetmc.BanFromClaim.handler.MessageHandler;
import no.vestlandetmc.BanFromClaim.handler.Permissions;
import no.vestlandetmc.BanFromClaim.hooks.RegionHook;
import no.vestlandetmc.BanFromClaim.utils.LocationFinder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class KfcCommand
implements BasicCommand {
    public void execute(CommandSourceStack commandSourceStack, String[] args) {
        boolean allowBan;
        CommandSender commandSender = commandSourceStack.getSender();
        if (!(commandSender instanceof Player)) {
            MessageHandler.sendConsole("&cThis command can only be used in-game.");
            return;
        }
        Player player = (Player)commandSender;
        RegionHook region = BfcPlugin.getHookManager().getActiveRegionHook();
        String regionID = region.getRegionID(player);
        if (args.length == 0) {
            MessageHandler.sendMessage(player, Messages.NO_ARGUMENTS);
            return;
        }
        if (regionID == null) {
            MessageHandler.sendMessage(player, Messages.OUTSIDE_CLAIM);
            return;
        }
        Player kickedPlayer = Bukkit.getPlayer((String)args[0]);
        boolean bl = allowBan = player.hasPermission("bfc.admin") || region.isOwner((OfflinePlayer)player, regionID) || region.isManager((OfflinePlayer)player, regionID);
        if (kickedPlayer == null) {
            MessageHandler.sendMessage(player, Messages.placeholders(Messages.UNVALID_PLAYERNAME, args[0], player.getDisplayName(), null));
            return;
        }
        if (kickedPlayer == player) {
            MessageHandler.sendMessage(player, Messages.KICK_SELF);
            return;
        }
        if (region.isOwner((OfflinePlayer)kickedPlayer, regionID)) {
            MessageHandler.sendMessage(player, Messages.KICK_OWNER);
            return;
        }
        if (kickedPlayer.hasPermission("bfc.bypass")) {
            MessageHandler.sendMessage(player, Messages.placeholders(Messages.PROTECTED, kickedPlayer.getDisplayName(), null, null));
            return;
        }
        if (!allowBan) {
            MessageHandler.sendMessage(player, Messages.NO_ACCESS);
        } else {
            String claimOwner = region.getClaimOwnerName(regionID);
            int sizeRadius = region.sizeRadius(regionID);
            Location greaterCorner = region.getGreaterBoundaryCorner(regionID);
            Location lesserCorner = region.getLesserBoundaryCorner(regionID);
            if (region.isInsideRegion(kickedPlayer, regionID)) {
                Location bannedLoc = kickedPlayer.getLocation();
                LocationFinder lf = new LocationFinder(greaterCorner, lesserCorner, bannedLoc.getWorld().getUID(), sizeRadius);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)BfcPlugin.getPlugin(), () -> lf.IterateCircumferences(randomCircumferenceRadiusLoc -> {
                    if (randomCircumferenceRadiusLoc == null) {
                        if (Config.SAFE_LOCATION == null) {
                            kickedPlayer.teleport(bannedLoc.getWorld().getSpawnLocation());
                        } else {
                            kickedPlayer.teleport(Config.SAFE_LOCATION);
                        }
                    } else {
                        kickedPlayer.teleport(randomCircumferenceRadiusLoc);
                    }
                    MessageHandler.sendMessage(kickedPlayer, Messages.placeholders(Messages.KICKED_TARGET, kickedPlayer.getName(), player.getDisplayName(), claimOwner));
                }));
            }
        }
        MessageHandler.sendMessage(player, Messages.placeholders(Messages.KICKED, kickedPlayer.getName(), null, null));
    }

    public Collection<String> suggest(CommandSourceStack commandSourceStack, String[] args) {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).toList();
    }

    public boolean canUse(CommandSender sender) {
        return super.canUse(sender);
    }

    public @Nullable String permission() {
        return Permissions.KICK.getName();
    }
}

