/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.BanFromClaim.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import no.vestlandetmc.BanFromClaim.BfcPlugin;
import no.vestlandetmc.BanFromClaim.config.ClaimData;
import no.vestlandetmc.BanFromClaim.config.Messages;
import no.vestlandetmc.BanFromClaim.handler.MessageHandler;
import no.vestlandetmc.BanFromClaim.handler.Permissions;
import no.vestlandetmc.BanFromClaim.hooks.RegionHook;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class UnbfcCommand
implements BasicCommand {
    public void execute(CommandSourceStack commandSourceStack, String[] args) {
        CommandSender commandSender = commandSourceStack.getSender();
        if (!(commandSender instanceof Player)) {
            MessageHandler.sendConsole("&cThis command can only be used in-game.");
            return;
        }
        Player player = (Player)commandSender;
        RegionHook region = BfcPlugin.getHookManager().getActiveRegionHook();
        String regionID = region.getRegionID(player);
        if (args.length == 0) {
            MessageHandler.sendMessage(player, Messages.NO_ARGUMENTS);
            return;
        }
        if (regionID == null) {
            MessageHandler.sendMessage(player, Messages.OUTSIDE_CLAIM);
            return;
        }
        boolean allowBan = player.hasPermission("bfc.admin") || region.isOwner((OfflinePlayer)player, regionID) || region.isManager((OfflinePlayer)player, regionID);
        OfflinePlayer bPlayer = null;
        if (!allowBan) {
            MessageHandler.sendMessage(player, Messages.NO_ACCESS);
            return;
        }
        String claimOwner = region.getClaimOwnerName(regionID);
        if (this.listPlayers(regionID) != null) {
            for (String bp : this.listPlayers(regionID)) {
                OfflinePlayer bannedPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(bp));
                String bannedPlayerName = bannedPlayer.getName();
                if (bannedPlayerName == null) {
                    this.setClaimData(regionID, bp, false);
                    continue;
                }
                if (!bannedPlayerName.equalsIgnoreCase(args[0])) continue;
                bPlayer = bannedPlayer;
                if (!this.setClaimData(regionID, bp, false)) continue;
                MessageHandler.sendMessage(player, Messages.placeholders(Messages.UNBANNED, bannedPlayer.getName(), player.getDisplayName(), claimOwner));
                if (bannedPlayer.isOnline()) {
                    MessageHandler.sendMessage(bannedPlayer.getPlayer(), Messages.placeholders(Messages.UNBANNED_TARGET, bannedPlayer.getName(), player.getDisplayName(), claimOwner));
                }
                return;
            }
        }
        if (bPlayer == null) {
            MessageHandler.sendMessage(player, Messages.placeholders(Messages.NOT_BANNED, args[0], player.getDisplayName(), null));
        }
    }

    public Collection<String> suggest(CommandSourceStack commandSourceStack, String[] args) {
        return super.suggest(commandSourceStack, args);
    }

    public boolean canUse(CommandSender sender) {
        return super.canUse(sender);
    }

    public @Nullable String permission() {
        return Permissions.UNBAN.getName();
    }

    private List<String> listPlayers(String claimID) {
        ClaimData claimData = new ClaimData();
        return claimData.bannedPlayers(claimID);
    }

    private boolean setClaimData(String claimID, String bannedUUID, boolean add) {
        ClaimData claimData = new ClaimData();
        return claimData.setClaimData(claimID, bannedUUID, add);
    }
}

