/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.BanFromClaim.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import no.vestlandetmc.BanFromClaim.BfcPlugin;
import org.bukkit.configuration.file.FileConfiguration;

public class ClaimData {
    private final FileConfiguration cfg = BfcPlugin.getDataFile();
    private final String prefix = "bfc_claim_data";

    public boolean setClaimData(String claimID, String bannedUUID, boolean add) {
        if (add) {
            if (!this.existData(claimID, bannedUUID)) {
                this.addData(claimID, bannedUUID);
                return true;
            }
            return false;
        }
        if (this.existData(claimID, bannedUUID)) {
            this.removeData(claimID, bannedUUID);
            return true;
        }
        return false;
    }

    public void changeRegionID(String oldID, String newID) {
        if (this.cfg.contains("bfc_claim_data." + oldID)) {
            if (this.cfg.getStringList("bfc_claim_data." + oldID).isEmpty()) {
                this.cfg.set("bfc_claim_data." + oldID, null);
            } else {
                List<String> uuid = this.bannedPlayers(oldID);
                boolean banAll = false;
                if (this.cfg.contains("claims-ban-all." + oldID + ".ban-all")) {
                    banAll = this.cfg.getBoolean("claims-ban-all." + oldID + ".ban-all");
                }
                this.cfg.createSection("bfc_claim_data." + newID);
                this.cfg.set("claims-ban-all." + newID + ".ban-all", (Object)banAll);
                if (uuid != null && !uuid.isEmpty()) {
                    this.cfg.set("bfc_claim_data." + newID, uuid);
                }
                this.cfg.set("claims-ban-all." + oldID, null);
                this.cfg.set("bfc_claim_data." + oldID, null);
                ClaimData.saveDatafile();
            }
        }
    }

    private void addData(String claimID, String bannedUUID) {
        ArrayList<String> uuid = new ArrayList<String>();
        if (!this.cfg.contains("bfc_claim_data." + claimID)) {
            this.cfg.createSection("bfc_claim_data." + claimID);
        }
        if (!this.cfg.getStringList("bfc_claim_data." + claimID).isEmpty()) {
            uuid.addAll(this.cfg.getStringList("bfc_claim_data." + claimID));
        }
        uuid.add(bannedUUID);
        this.cfg.set("bfc_claim_data." + claimID, uuid);
        ClaimData.saveDatafile();
    }

    public void banAll(String claimID) {
        if (this.cfg.contains("claims-ban-all." + claimID + ".ban-all")) {
            if (this.cfg.getBoolean("claims-ban-all." + claimID + ".ban-all")) {
                this.cfg.set("claims-ban-all." + claimID + ".ban-all", (Object)false);
            } else {
                this.cfg.set("claims-ban-all." + claimID + ".ban-all", (Object)true);
            }
        } else {
            this.cfg.set("claims-ban-all." + claimID + ".ban-all", (Object)true);
        }
        ClaimData.saveDatafile();
    }

    public boolean isAllBanned(String claimID) {
        if (this.cfg.contains("claims-ban-all." + claimID + ".ban-all")) {
            return this.cfg.getBoolean("claims-ban-all." + claimID + ".ban-all");
        }
        return false;
    }

    private void removeData(String claimID, String bannedUUID) {
        ArrayList uuid;
        if (!this.cfg.getStringList("bfc_claim_data." + claimID).isEmpty() && (uuid = new ArrayList(this.cfg.getStringList("bfc_claim_data." + claimID))).contains(bannedUUID)) {
            uuid.remove(bannedUUID);
            this.cfg.set("bfc_claim_data." + claimID, uuid);
            if (this.cfg.getStringList("bfc_claim_data." + claimID).isEmpty()) {
                this.cfg.set("bfc_claim_data." + claimID, null);
            }
            ClaimData.saveDatafile();
        }
    }

    private boolean existData(String claimID, String bannedUUID) {
        if (this.cfg.contains("bfc_claim_data." + claimID)) {
            if (this.cfg.getStringList("bfc_claim_data." + claimID).isEmpty()) {
                return false;
            }
            ArrayList uuid = new ArrayList(this.cfg.getStringList("bfc_claim_data." + claimID));
            return uuid.contains(bannedUUID);
        }
        return false;
    }

    public boolean checkClaim(String claimID) {
        return this.cfg.contains("bfc_claim_data." + claimID);
    }

    public List<String> bannedPlayers(String claimID) {
        if (this.cfg.contains("bfc_claim_data." + claimID) && !this.cfg.getStringList("bfc_claim_data." + claimID).isEmpty()) {
            return this.cfg.getStringList("bfc_claim_data." + claimID);
        }
        return null;
    }

    public static void saveDatafile() {
        try {
            File file = new File(BfcPlugin.getPlugin().getDataFolder(), "data.dat");
            BfcPlugin.getDataFile().save(file);
        }
        catch (IOException e) {
            BfcPlugin.getPlugin().getLogger().severe(e.getMessage());
        }
    }

    public static void createSection() {
        if (!BfcPlugin.getDataFile().contains("bfc_claim_data")) {
            BfcPlugin.getDataFile().createSection("bfc_claim_data");
        }
        if (!BfcPlugin.getDataFile().contains("claims-ban-all")) {
            BfcPlugin.getDataFile().createSection("claims-ban-all");
        }
        ClaimData.saveDatafile();
    }
}

