/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.BanFromClaim.config;

import no.vestlandetmc.BanFromClaim.config.ConfigHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class Config
extends ConfigHandler {
    public static long COMBAT_TIME;
    public static boolean COMBAT_ENABLED;
    public static boolean TIMER_ENABLED;
    public static boolean KICKMODE;
    public static Location SAFE_LOCATION;

    private Config(String fileName) {
        super(fileName);
    }

    private void onLoad() {
        if (this.contains("teleport.safelocation")) {
            double locX = this.getDouble("teleport.safelocation.x");
            double locY = this.getDouble("teleport.safelocation.y");
            double locZ = this.getDouble("teleport.safelocation.z");
            float yaw = this.getInt("teleport.safelocation.yaw");
            String worldName = this.getString("teleport.safelocation.world");
            World world = Bukkit.getWorld((String)worldName);
            SAFE_LOCATION = new Location(world, locX, locY, locZ, yaw, 0.0f);
        } else {
            SAFE_LOCATION = null;
        }
        COMBAT_TIME = this.getLong("combatmode.time");
        COMBAT_ENABLED = this.getBoolean("combatmode.enabled");
        TIMER_ENABLED = this.getBoolean("combatmode.timer-enabled");
        KICKMODE = this.getBoolean("kickmode");
    }

    public static void initialize() {
        new Config("config.yml").onLoad();
    }

    public static void setSafespot(Location loc) {
        ConfigHandler cfg = new ConfigHandler("config.yml");
        double locX = loc.getX();
        double locY = loc.getY();
        double locZ = loc.getZ();
        float yaw = loc.getYaw();
        World world = loc.getWorld();
        cfg.set("teleport.safelocation.x", locX);
        cfg.set("teleport.safelocation.y", locY);
        cfg.set("teleport.safelocation.z", locZ);
        cfg.set("teleport.safelocation.yaw", Float.valueOf(yaw));
        cfg.set("teleport.safelocation.world", world.getName());
        cfg.saveConfig();
        SAFE_LOCATION = new Location(world, locX, locY, locZ, yaw, 0.0f);
    }
}

