/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.BanFromClaim.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Set;
import no.vestlandetmc.BanFromClaim.BfcPlugin;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigHandler
extends YamlConfiguration {
    private final File file;
    private final YamlConfiguration defaults;
    private String pathPrefix;

    public ConfigHandler(String fileName) {
        this(fileName, true);
    }

    public ConfigHandler(String fileName, boolean useDefaults) {
        this.defaults = useDefaults ? YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(ConfigHandler.class.getResourceAsStream("/" + fileName), StandardCharsets.UTF_8)) : null;
        this.file = this.extract(fileName);
        this.loadConfig();
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public void reloadConfig() {
        this.saveConfig();
        this.loadConfig();
    }

    public void write(String path, Object value) {
        this.set(path, value);
        this.reloadConfig();
    }

    public void saveConfig() {
        try {
            super.save(this.file);
        }
        catch (IOException ex) {
            System.out.println("Failed to save configuration from " + String.valueOf(this.file));
            Bukkit.getLogger().severe(ex.getMessage());
        }
    }

    private void loadConfig() {
        try {
            super.load(this.file);
        }
        catch (Throwable t) {
            System.out.println("Failed to load configuration from " + String.valueOf(this.file));
            Bukkit.getLogger().severe(t.getMessage());
        }
    }

    public Object get(String path, Object def) {
        if (this.defaults != null) {
            if (def != null && !def.getClass().isPrimitive() && !PrimitiveWrapper.isWrapperType(def.getClass())) {
                throw new IllegalArgumentException("The default value must be null since we use defaults from file inside of the plugin! Path: " + (String)path + ", default called: " + String.valueOf(def));
            }
            if (super.get((String)path, null) == null) {
                Object defaultValue = this.defaults.get((String)path);
                this.write((String)path, defaultValue);
            }
        }
        String m = new Throwable().getStackTrace()[1].getMethodName();
        if (this.defaults == null && this.pathPrefix != null && !m.equals("getConfigurationSection") && !m.equals("get")) {
            path = this.pathPrefix + "." + (String)path;
        }
        return super.get((String)path, null);
    }

    public void set(String path, Object value) {
        String m = new Throwable().getStackTrace()[1].getMethodName();
        if (this.defaults == null && this.pathPrefix != null && !m.equals("getConfigurationSection") && !m.equals("get")) {
            path = this.pathPrefix + "." + (String)path;
        }
        super.set((String)path, value);
    }

    private File extract(String path) {
        BfcPlugin i = BfcPlugin.getPlugin();
        File file = new File(i.getDataFolder(), path);
        if (file.exists()) {
            return file;
        }
        this.createFileAndDirectory(path);
        if (this.defaults != null) {
            try (InputStream is = i.getResource(path);){
                Files.copy(is, Paths.get(file.toURI()), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                Bukkit.getLogger().severe(e.getMessage());
            }
        }
        return file;
    }

    private File createFileAndDirectory(String path) {
        File datafolder = BfcPlugin.getPlugin().getDataFolder();
        int lastIndex = path.lastIndexOf(47);
        File directory = new File(datafolder, path.substring(0, Math.max(lastIndex, 0)));
        directory.mkdirs();
        File destination = new File(datafolder, path);
        try {
            destination.createNewFile();
        }
        catch (IOException ex) {
            System.out.println("Failed to create file " + path);
            Bukkit.getLogger().severe(ex.getMessage());
        }
        return destination;
    }

    private static final class PrimitiveWrapper {
        private static final Set<Class<?>> WRAPPER_TYPES = PrimitiveWrapper.getWrapperTypes();

        private PrimitiveWrapper() {
        }

        private static boolean isWrapperType(Class<?> clazz) {
            return WRAPPER_TYPES.contains(clazz);
        }

        private static Set<Class<?>> getWrapperTypes() {
            HashSet ret = new HashSet();
            ret.add(Boolean.class);
            ret.add(Character.class);
            ret.add(Byte.class);
            ret.add(Short.class);
            ret.add(Integer.class);
            ret.add(Long.class);
            ret.add(Float.class);
            ret.add(Double.class);
            ret.add(Void.class);
            return ret;
        }
    }
}

