/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.BanFromClaim.hooks;

import com.griefdefender.api.Core;
import com.griefdefender.api.GriefDefender;
import com.griefdefender.api.claim.Claim;
import com.griefdefender.api.claim.TrustTypes;
import com.griefdefender.api.event.RemoveClaimEvent;
import com.griefdefender.lib.flowpowered.math.vector.Vector3i;
import com.griefdefender.lib.kyori.event.EventSubscriber;
import java.util.UUID;
import no.vestlandetmc.BanFromClaim.BfcPlugin;
import no.vestlandetmc.BanFromClaim.config.ClaimData;
import no.vestlandetmc.BanFromClaim.hooks.RegionHook;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GriefDefenderHook
implements RegionHook {
    public GriefDefenderHook() {
        this.registerDeleteClaimEvent();
    }

    @Override
    public boolean isInsideRegion(Player player) {
        Location loc = player.getLocation();
        Vector3i vector = Vector3i.from((int)loc.getBlockX(), (int)loc.getBlockY(), (int)loc.getBlockZ());
        Core gd = GriefDefender.getCore();
        Claim claim = gd.getClaimManager(loc.getWorld().getUID()).getClaimAt(vector);
        return !claim.isWilderness();
    }

    @Override
    public boolean isInsideRegion(Player player, String regionID) {
        Core gd = GriefDefender.getCore();
        Claim claim = gd.getClaim(UUID.fromString(regionID));
        return claim.contains(player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ());
    }

    @Override
    public boolean isManager(OfflinePlayer player, String regionID) {
        Core gd = GriefDefender.getCore();
        Claim claim = gd.getClaim(UUID.fromString(regionID));
        return claim.getUserTrusts(TrustTypes.MANAGER).contains(player.getUniqueId());
    }

    @Override
    public String getRegionID(Player player) {
        return this.getRegionID(player.getLocation());
    }

    @Override
    public String getRegionID(Location location) {
        Vector3i vector = Vector3i.from((int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ());
        Core gd = GriefDefender.getCore();
        Claim claim = gd.getClaimManager(location.getWorld().getUID()).getClaimAt(vector);
        return !claim.isWilderness() ? claim.getUniqueId().toString() : null;
    }

    @Override
    public Object getRegion(Player player) {
        return this.getRegion(player.getLocation());
    }

    @Override
    public Object getRegion(Location location) {
        Vector3i vector = Vector3i.from((int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ());
        Core gd = GriefDefender.getCore();
        Claim claim = gd.getClaimManager(location.getWorld().getUID()).getClaimAt(vector);
        return !claim.isWilderness() ? claim : null;
    }

    @Override
    public Location getGreaterBoundaryCorner(String regionID) {
        Core gd = GriefDefender.getCore();
        Claim claim = gd.getClaim(UUID.fromString(regionID));
        return new Location(Bukkit.getWorld((UUID)claim.getWorldUniqueId()), (double)claim.getGreaterBoundaryCorner().getX(), 64.0, (double)claim.getGreaterBoundaryCorner().getZ());
    }

    @Override
    public Location getLesserBoundaryCorner(String regionID) {
        Core gd = GriefDefender.getCore();
        Claim claim = gd.getClaim(UUID.fromString(regionID));
        return new Location(Bukkit.getWorld((UUID)claim.getWorldUniqueId()), (double)claim.getLesserBoundaryCorner().getX(), 64.0, (double)claim.getLesserBoundaryCorner().getZ());
    }

    @Override
    public int sizeRadius(String regionID) {
        Core gd = GriefDefender.getCore();
        Claim claim = gd.getClaim(UUID.fromString(regionID));
        return Math.max(claim.getLength(), claim.getWidth());
    }

    @Override
    public boolean isOwner(OfflinePlayer player, String claimID) {
        Core gd = GriefDefender.getCore();
        Claim claim = gd.getClaim(UUID.fromString(claimID));
        return player.getUniqueId().toString().equals(claim.getOwnerUniqueId().toString());
    }

    @Override
    public UUID getOwnerID(String regionID) {
        Core gd = GriefDefender.getCore();
        Claim claim = gd.getClaim(UUID.fromString(regionID));
        return claim != null ? claim.getOwnerUniqueId() : null;
    }

    @Override
    public String getClaimOwnerName(String regionID) {
        Core gd = GriefDefender.getCore();
        Claim claim = gd.getClaim(UUID.fromString(regionID));
        return claim.getOwnerName();
    }

    @Override
    public boolean hasTrust(OfflinePlayer player, String regionID) {
        return false;
    }

    @Override
    public boolean regionExist(String regionID) {
        Core gd = GriefDefender.getCore();
        Claim claim = gd.getClaim(UUID.fromString(regionID));
        return claim != null && !claim.isWilderness();
    }

    private void registerDeleteClaimEvent() {
        GriefDefender.getEventManager().getBus().subscribe(RemoveClaimEvent.class, (EventSubscriber)new EventSubscriber<RemoveClaimEvent>(this){

            public void on(@NonNull RemoveClaimEvent event) throws Throwable {
                FileConfiguration data = BfcPlugin.getDataFile();
                boolean dataChange = false;
                if (data.contains("bfc_claim_data." + event.getClaim().getUniqueId().toString())) {
                    data.set("bfc_claim_data." + event.getClaim().getUniqueId().toString(), null);
                    dataChange = true;
                }
                if (data.contains("claims-ban-all." + event.getClaim().getUniqueId().toString())) {
                    data.set("claims-ban-all." + event.getClaim().getUniqueId().toString(), null);
                    dataChange = true;
                }
                if (dataChange) {
                    ClaimData.saveDatafile();
                }
            }
        });
    }
}

