/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.BanFromClaim.hooks;

import java.util.UUID;
import java.util.function.Supplier;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.events.ClaimDeletedEvent;
import no.vestlandetmc.BanFromClaim.BfcPlugin;
import no.vestlandetmc.BanFromClaim.config.ClaimData;
import no.vestlandetmc.BanFromClaim.hooks.RegionHook;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class GriefPreventionHook
implements RegionHook,
Listener {
    @Override
    public boolean isInsideRegion(Player player) {
        Location loc = player.getLocation();
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(loc, true, null);
        return claim != null;
    }

    @Override
    public boolean isInsideRegion(Player player, String regionID) {
        Claim claim = GriefPrevention.instance.dataStore.getClaim(Long.parseLong(regionID));
        return claim.contains(player.getLocation(), true, false);
    }

    @Override
    public boolean isManager(OfflinePlayer player, String regionID) {
        Claim claim = GriefPrevention.instance.dataStore.getClaim(Long.parseLong(regionID));
        Supplier isManager = claim.checkPermission(player.getUniqueId(), ClaimPermission.Manage, null);
        return isManager == null;
    }

    @Override
    public String getRegionID(Player player) {
        return this.getRegionID(player.getLocation());
    }

    @Override
    public String getRegionID(Location location) {
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(location, true, null);
        return claim != null ? claim.getID().toString() : null;
    }

    @Override
    public Object getRegion(Player player) {
        return this.getRegion(player.getLocation());
    }

    @Override
    public Object getRegion(Location location) {
        return GriefPrevention.instance.dataStore.getClaimAt(location, true, null);
    }

    @Override
    public Location getGreaterBoundaryCorner(String regionID) {
        Claim claim = GriefPrevention.instance.dataStore.getClaim(Long.parseLong(regionID));
        return claim.getGreaterBoundaryCorner();
    }

    @Override
    public Location getLesserBoundaryCorner(String regionID) {
        Claim claim = GriefPrevention.instance.dataStore.getClaim(Long.parseLong(regionID));
        return claim.getLesserBoundaryCorner();
    }

    @Override
    public int sizeRadius(String regionID) {
        Claim claim = GriefPrevention.instance.dataStore.getClaim(Long.parseLong(regionID));
        return Math.max(claim.getHeight(), claim.getWidth());
    }

    @Override
    public boolean isOwner(OfflinePlayer player, String claimID) {
        Claim claim = GriefPrevention.instance.dataStore.getClaim(Long.parseLong(claimID));
        return player.getUniqueId().toString().equals(claim.getOwnerID().toString());
    }

    @Override
    public UUID getOwnerID(String regionID) {
        Claim claim = GriefPrevention.instance.dataStore.getClaim(Long.parseLong(regionID));
        return claim != null ? claim.getOwnerID() : null;
    }

    @Override
    public String getClaimOwnerName(String regionID) {
        Claim claim = GriefPrevention.instance.dataStore.getClaim(Long.parseLong(regionID));
        return claim.getOwnerName();
    }

    @Override
    public boolean hasTrust(OfflinePlayer player, String regionID) {
        Claim claim = GriefPrevention.instance.dataStore.getClaim(Long.parseLong(regionID));
        for (ClaimPermission claimPermission : ClaimPermission.values()) {
            if (claimPermission == ClaimPermission.Edit || claim.checkPermission(player.getUniqueId(), claimPermission, null) != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean regionExist(String regionID) {
        Claim claim = GriefPrevention.instance.dataStore.getClaim(Long.parseLong(regionID));
        return claim != null;
    }

    @EventHandler
    public void deleteClaim(ClaimDeletedEvent e) {
        FileConfiguration data = BfcPlugin.getDataFile();
        boolean dataChange = false;
        if (data.contains("bfc_claim_data." + e.getClaim().getID())) {
            data.set("bfc_claim_data." + e.getClaim().getID(), null);
            dataChange = true;
        }
        if (data.contains("claims-ban-all." + e.getClaim().getID())) {
            data.set("claims-ban-all." + e.getClaim().getID(), null);
            dataChange = true;
        }
        if (dataChange) {
            ClaimData.saveDatafile();
        }
    }
}

