/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.BanFromClaim.hooks;

import lombok.Generated;
import no.vestlandetmc.BanFromClaim.BfcPlugin;
import no.vestlandetmc.BanFromClaim.hooks.GriefDefenderHook;
import no.vestlandetmc.BanFromClaim.hooks.GriefPreventionHook;
import no.vestlandetmc.BanFromClaim.hooks.RegionHook;
import no.vestlandetmc.BanFromClaim.hooks.ResidenceHook;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class HookManager {
    private RegionHook activeRegionHook;

    public HookManager() {
        if (this.isPluginAvailable("GriefPrevention")) {
            this.activeRegionHook = new GriefPreventionHook();
            BfcPlugin.getPlugin().getLogger().info("GriefPrevention detected and hooked.");
        } else if (this.isPluginAvailable("GriefDefender")) {
            this.activeRegionHook = new GriefDefenderHook();
            BfcPlugin.getPlugin().getLogger().info("GriefDefender detected and hooked.");
        } else if (this.isPluginAvailable("Residence")) {
            this.activeRegionHook = new ResidenceHook();
            BfcPlugin.getPlugin().getServer().getPluginManager().registerEvents((Listener)new ResidenceHook(), (Plugin)BfcPlugin.getPlugin());
            BfcPlugin.getPlugin().getLogger().info("Residence detected and hooked.");
        } else {
            BfcPlugin.getPlugin().getLogger().warning("No supported protection plugins found!");
            Bukkit.getPluginManager().disablePlugin((Plugin)BfcPlugin.getPlugin());
        }
        if (this.activeRegionHook instanceof Listener) {
            Bukkit.getPluginManager().registerEvents((Listener)this.activeRegionHook, (Plugin)BfcPlugin.getPlugin());
        }
    }

    private boolean isPluginAvailable(String pluginName) {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin(pluginName);
        return plugin != null && plugin.isEnabled();
    }

    @Generated
    public RegionHook getActiveRegionHook() {
        return this.activeRegionHook;
    }
}

