/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.BanFromClaim.hooks;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.api.ResidenceInterface;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceRenameEvent;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.UUID;
import no.vestlandetmc.BanFromClaim.BfcPlugin;
import no.vestlandetmc.BanFromClaim.config.ClaimData;
import no.vestlandetmc.BanFromClaim.hooks.RegionHook;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class ResidenceHook
implements RegionHook,
Listener {
    @Override
    public boolean isInsideRegion(Player player) {
        ResidenceInterface res = Residence.getInstance().getResidenceManagerAPI();
        ClaimedResidence region = res.getByLoc(player.getLocation());
        return region != null;
    }

    @Override
    public boolean isInsideRegion(Player player, String regionID) {
        ResidenceInterface res = Residence.getInstance().getResidenceManagerAPI();
        ClaimedResidence region = res.getByName(regionID);
        return region != null && region.containsLoc(player.getLocation());
    }

    @Override
    public boolean isManager(OfflinePlayer player, String regionID) {
        return false;
    }

    @Override
    public String getRegionID(Player player) {
        return this.getRegionID(player.getLocation());
    }

    @Override
    public String getRegionID(Location location) {
        ResidenceInterface res = Residence.getInstance().getResidenceManagerAPI();
        ClaimedResidence region = res.getByLoc(location);
        return region != null ? region.getResidenceName() : null;
    }

    @Override
    public Object getRegion(Player player) {
        return this.getRegion(player.getLocation());
    }

    @Override
    public Object getRegion(Location location) {
        ResidenceInterface res = Residence.getInstance().getResidenceManagerAPI();
        return res.getByLoc(location);
    }

    @Override
    public Location getGreaterBoundaryCorner(String regionID) {
        ResidenceInterface res = Residence.getInstance().getResidenceManagerAPI();
        ClaimedResidence region = res.getByName(regionID);
        return region.getMainArea().getHighLocation();
    }

    @Override
    public Location getLesserBoundaryCorner(String regionID) {
        ResidenceInterface res = Residence.getInstance().getResidenceManagerAPI();
        ClaimedResidence region = res.getByName(regionID);
        return region.getMainArea().getLowLocation();
    }

    @Override
    public int sizeRadius(String regionID) {
        ResidenceInterface res = Residence.getInstance().getResidenceManagerAPI();
        ClaimedResidence region = res.getByName(regionID);
        return Math.max(region.getMainArea().getXSize(), region.getMainArea().getZSize());
    }

    @Override
    public boolean isOwner(OfflinePlayer player, String claimID) {
        ResidenceInterface res = Residence.getInstance().getResidenceManagerAPI();
        ClaimedResidence region = res.getByName(claimID);
        return region.isOwner(player.getUniqueId());
    }

    @Override
    public UUID getOwnerID(String regionID) {
        ResidenceInterface res = Residence.getInstance().getResidenceManagerAPI();
        ClaimedResidence region = res.getByName(regionID);
        return region != null ? region.getOwnerUUID() : null;
    }

    @Override
    public String getClaimOwnerName(String regionID) {
        ResidenceInterface res = Residence.getInstance().getResidenceManagerAPI();
        ClaimedResidence region = res.getByName(regionID);
        return region.getOwner();
    }

    @Override
    public boolean hasTrust(OfflinePlayer player, String regionID) {
        ResidenceInterface res = Residence.getInstance().getResidenceManagerAPI();
        ClaimedResidence region = res.getByName(regionID);
        return region.isTrusted(player.getName());
    }

    @Override
    public boolean regionExist(String regionID) {
        ResidenceInterface res = Residence.getInstance().getResidenceManagerAPI();
        ClaimedResidence region = res.getByName(regionID);
        return region != null;
    }

    @EventHandler
    public void residenceRename(ResidenceRenameEvent e) {
        ClaimData claimData = new ClaimData();
        claimData.changeRegionID(e.getOldResidenceName(), e.getNewResidenceName());
    }

    @EventHandler
    public void deleteClaim(ResidenceDeleteEvent e) {
        FileConfiguration data = BfcPlugin.getDataFile();
        boolean dataChange = false;
        if (data.contains("bfc_claim_data." + e.getResidence().getResidenceName())) {
            data.set("bfc_claim_data." + e.getResidence().getResidenceName(), null);
            dataChange = true;
        }
        if (data.contains("claims-ban-all." + e.getResidence().getResidenceName())) {
            data.set("claims-ban-all." + e.getResidence().getResidenceName(), null);
            dataChange = true;
        }
        if (dataChange) {
            ClaimData.saveDatafile();
        }
    }
}

