/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.BanFromClaim.listener;

import java.util.UUID;
import no.vestlandetmc.BanFromClaim.BfcPlugin;
import no.vestlandetmc.BanFromClaim.config.ClaimData;
import no.vestlandetmc.BanFromClaim.config.Config;
import no.vestlandetmc.BanFromClaim.config.Messages;
import no.vestlandetmc.BanFromClaim.handler.MessageHandler;
import no.vestlandetmc.BanFromClaim.handler.ParticleHandler;
import no.vestlandetmc.BanFromClaim.hooks.RegionHook;
import no.vestlandetmc.BanFromClaim.listener.CombatMode;
import no.vestlandetmc.BanFromClaim.utils.LocationFinder;
import no.vestlandetmc.BanFromClaim.utils.PlayerRidePlayer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class RegionListener
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onPlayerEnterClaim(PlayerMoveEvent e) {
        ClaimData claimData = new ClaimData();
        Location locFrom = e.getFrom();
        Location locTo = e.getTo();
        if (locFrom.getBlock().equals((Object)locTo.getBlock())) {
            return;
        }
        Player player = e.getPlayer();
        RegionHook regionHook = BfcPlugin.getHookManager().getActiveRegionHook();
        String regionID = regionHook.getRegionID(locTo);
        ParticleHandler ph = new ParticleHandler(locTo);
        if (regionID == null) {
            return;
        }
        UUID ownerUUID = regionHook.getOwnerID(regionID);
        if (ownerUUID == null) {
            return;
        }
        Player target = PlayerRidePlayer.getPassenger(player);
        boolean hasAttacked = false;
        if (target != null && !regionHook.hasTrust((OfflinePlayer)target, regionID) && !this.canBypass(target) && (claimData.isAllBanned(regionID) || this.playerBanned(target, regionID) || this.playerBanned(player, regionID))) {
            target.teleport(player.getLocation().add(0.0, 4.0, 0.0));
        }
        if (CombatMode.attackerContains(player.getUniqueId())) {
            hasAttacked = CombatMode.getAttacker(player.getUniqueId()).equals(ownerUUID);
        }
        if (this.canBypass(player)) {
            return;
        }
        if ((claimData.isAllBanned(regionID) || this.playerBanned(player, regionID)) && !hasAttacked && !regionHook.hasTrust((OfflinePlayer)player, regionID)) {
            String regionIdFrom = regionHook.getRegionID(locFrom);
            if (regionIdFrom != null && regionIdFrom.equals(regionID)) {
                if (this.playerBanned(player, regionID) || claimData.isAllBanned(regionID)) {
                    int sizeRadius = regionHook.sizeRadius(regionID);
                    Location greaterBoundaryCorner = regionHook.getGreaterBoundaryCorner(regionID);
                    Location lesserBoundaryCorner = regionHook.getLesserBoundaryCorner(regionID);
                    LocationFinder lf = new LocationFinder(greaterBoundaryCorner, lesserBoundaryCorner, player.getWorld().getUID(), sizeRadius);
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)BfcPlugin.getPlugin(), () -> lf.IterateCircumferences(randomCircumferenceRadiusLoc -> {
                        if (randomCircumferenceRadiusLoc == null) {
                            if (Config.SAFE_LOCATION == null) {
                                player.teleport(player.getWorld().getSpawnLocation());
                            } else {
                                player.teleport(Config.SAFE_LOCATION);
                            }
                        } else {
                            player.teleport(randomCircumferenceRadiusLoc);
                        }
                    }));
                } else {
                    Location tpLoc = player.getLocation().add(e.getFrom().toVector().subtract(e.getTo().toVector()).normalize().multiply(3));
                    if (tpLoc.getBlock().getType().equals((Object)Material.AIR)) {
                        player.teleport(tpLoc);
                    } else {
                        Location safeLoc = tpLoc.getWorld().getHighestBlockAt(tpLoc).getLocation().add(0.0, 1.0, 0.0);
                        player.teleport(safeLoc);
                    }
                    ph.drawCircle(1.0f, e.getTo().getBlockX() == e.getFrom().getBlockX());
                }
            } else {
                Location tpLoc = player.getLocation().add(e.getFrom().toVector().subtract(e.getTo().toVector()).normalize().multiply(3));
                if (tpLoc.getBlock().getType().equals((Object)Material.AIR)) {
                    player.teleport(tpLoc);
                } else {
                    Location safeLoc = tpLoc.getWorld().getHighestBlockAt(tpLoc).getLocation().add(0.0, 1.0, 0.0);
                    player.teleport(safeLoc);
                }
                ph.drawCircle(1.0f, e.getTo().getBlockX() == e.getFrom().getBlockX());
            }
            if (!MessageHandler.spamMessageClaim.contains(player.getUniqueId().toString())) {
                MessageHandler.sendTitle(player, Messages.TITLE_MESSAGE, Messages.SUBTITLE_MESSAGE);
                MessageHandler.spamMessageClaim.add(player.getUniqueId().toString());
                Bukkit.getScheduler().runTaskLater((Plugin)BfcPlugin.getPlugin(), () -> MessageHandler.spamMessageClaim.remove(player.getUniqueId().toString()), 100L);
            }
        }
    }

    private boolean canBypass(Player player) {
        return player.hasPermission("bfc.bypass") || player.getGameMode().equals((Object)GameMode.SPECTATOR);
    }

    private boolean playerBanned(Player player, String claimID) {
        ClaimData claimData = new ClaimData();
        if (claimData.checkClaim(claimID) && claimData.bannedPlayers(claimID) != null) {
            for (String bp : claimData.bannedPlayers(claimID)) {
                if (!bp.equals(player.getUniqueId().toString())) continue;
                return true;
            }
        }
        return false;
    }
}

