/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.BanFromClaim.utils;

import java.util.UUID;
import no.vestlandetmc.BanFromClaim.BfcPlugin;
import no.vestlandetmc.BanFromClaim.handler.CallbackReturnLocation;
import no.vestlandetmc.BanFromClaim.hooks.RegionHook;
import no.vestlandetmc.BanFromClaim.utils.SafeLocationCheck;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public class LocationFinder {
    private final Location circumferenceCenter;
    private final UUID circumferenceWorldUUID;
    private int circumferenceRadius;

    public LocationFinder(Location loc1, Location loc2, UUID circumferenceWorldUUID, int circumferenceRadius) {
        this.circumferenceCenter = this.findCenter(loc1, loc2);
        this.circumferenceWorldUUID = circumferenceWorldUUID;
        this.circumferenceRadius = circumferenceRadius;
    }

    public void IterateCircumferences(CallbackReturnLocation callback) {
        World circumferenceWorld = Bukkit.getWorld((UUID)this.circumferenceWorldUUID);
        BfcPlugin plugin = BfcPlugin.getPlugin();
        Location randomCircumferenceRadiusLoc = null;
        int maxCircleIterations = 10;
        int checkLocationsPerCircumference = 4;
        int maxSafeLocationFailures = 5;
        int safeLocationChecks = 0;
        block0: for (int i = 0; i < 10; ++i) {
            this.circumferenceRadius *= 2;
            for (int j = 0; j < 4; ++j) {
                randomCircumferenceRadiusLoc = this.GetRandomCircumferenceLoc(this.circumferenceCenter, this.circumferenceRadius, circumferenceWorld);
                if (this.hasClaim(randomCircumferenceRadiusLoc)) continue;
                ++safeLocationChecks;
                Block highestBlock = circumferenceWorld.getHighestBlockAt(randomCircumferenceRadiusLoc);
                if (SafeLocationCheck.BlockSafetyCheck(highestBlock)) {
                    randomCircumferenceRadiusLoc = new Location(circumferenceWorld, (double)highestBlock.getX() + 0.5, (double)(highestBlock.getY() + 1), (double)highestBlock.getZ() + 0.5);
                    break block0;
                }
                if (safeLocationChecks >= 5) continue;
                j = 0;
            }
            if (i != 9) continue;
            randomCircumferenceRadiusLoc = null;
        }
        Location finalRandomCircumferenceRadiusLoc = randomCircumferenceRadiusLoc;
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> callback.onDone(finalRandomCircumferenceRadiusLoc));
    }

    private Location GetRandomCircumferenceLoc(Location circumferenceCenter, int circumferenceRadius, World circumferenceWorld) {
        double randomAngle = Math.random() * Math.PI * 2.0;
        return new Location(circumferenceWorld, circumferenceCenter.getX() + Math.cos(randomAngle) * (double)circumferenceRadius, 120.0, circumferenceCenter.getZ() + Math.sin(randomAngle) * (double)circumferenceRadius);
    }

    private Location findCenter(Location loc1, Location loc2) {
        int minX = Math.min(loc1.getBlockX(), loc2.getBlockX());
        int minZ = Math.min(loc1.getBlockZ(), loc2.getBlockZ());
        int maxX = Math.max(loc1.getBlockX(), loc2.getBlockX());
        int maxZ = Math.max(loc1.getBlockZ(), loc2.getBlockZ());
        return new Location(loc1.getWorld(), (double)minX + (double)(maxX - minX) / 2.0, 64.0, (double)minZ + (double)(maxZ - minZ) / 2.0);
    }

    private boolean hasClaim(Location loc) {
        RegionHook region = BfcPlugin.getHookManager().getActiveRegionHook();
        String regionID = region.getRegionID(loc);
        return regionID != null;
    }
}

