/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5253;
import squeek.appleskin.ModConfig;

public class SaturationColorScreen
extends class_437 {
    private final class_437 parent;
    private ModConfig config;
    private class_357 redSlider;
    private class_357 greenSlider;
    private class_357 blueSlider;
    private class_357 hueSlider;
    private class_357 gammaSlider;
    private class_4185 modeToggleButton;
    private static final int PREVIEW_SIZE = 32;

    public SaturationColorScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Saturation Color Customization"));
        System.out.println("DEBUG: SaturationColorScreen constructor called");
        this.parent = parent;
        this.config = ModConfig.INSTANCE;
        System.out.println("DEBUG: SaturationColorScreen constructor completed, config: " + (this.config != null ? "loaded" : "null"));
    }

    protected void method_25426() {
        System.out.println("DEBUG: SaturationColorScreen.init() called");
        super.method_25426();
        System.out.println("DEBUG: super.init() completed");
        try {
            System.out.println("DEBUG: Starting screen initialization...");
            int centerX = this.field_22789 / 2;
            int startY = this.field_22790 / 4;
            System.out.println("DEBUG: Screen dimensions - width: " + this.field_22789 + ", height: " + this.field_22790);
            System.out.println("DEBUG: Creating mode toggle button...");
            this.modeToggleButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.config.useSaturationHSLMode ? "HSL Mode" : "RGB Mode")), button -> {
                System.out.println("DEBUG: Mode toggle clicked");
                this.config.useSaturationHSLMode = !this.config.useSaturationHSLMode;
                button.method_25355((class_2561)class_2561.method_43470((String)(this.config.useSaturationHSLMode ? "HSL Mode" : "RGB Mode")));
                this.rebuildSliders();
            }).method_46434(centerX - 50, startY, 100, 20).method_46431());
            System.out.println("DEBUG: Mode toggle button created");
            System.out.println("DEBUG: Building sliders...");
            this.buildSliders();
            System.out.println("DEBUG: Sliders built");
            System.out.println("DEBUG: Creating reset button...");
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset to Default"), button -> this.resetToDefaults()).method_46434(centerX - 150, this.field_22790 - 50, 100, 20).method_46431());
            System.out.println("DEBUG: Reset button created");
            System.out.println("DEBUG: Creating done button...");
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
                this.saveConfig();
                this.field_22787.method_1507(this.parent);
            }).method_46434(centerX + 50, this.field_22790 - 50, 100, 20).method_46431());
            System.out.println("DEBUG: Done button created");
            System.out.println("DEBUG: SaturationColorScreen initialization completed successfully");
        }
        catch (Exception e) {
            System.err.println("ERROR: Exception in SaturationColorScreen.init(): " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    private void buildSliders() {
        System.out.println("DEBUG: buildSliders() called");
        int centerX = this.field_22789 / 2;
        int startY = this.field_22790 / 4 + 30;
        System.out.println("DEBUG: buildSliders() - mode is " + (this.config.useSaturationHSLMode ? "HSL" : "RGB"));
        try {
            if (this.config.useSaturationHSLMode) {
                System.out.println("DEBUG: Creating HSL sliders...");
                System.out.println("DEBUG: Creating hue slider...");
                this.hueSlider = (class_357)this.method_37063((class_364)new class_357(centerX - 100, startY, 200, 20, (class_2561)class_2561.method_43470((String)("Hue: " + String.format("%.2f", Float.valueOf(this.config.saturationOverlayHue)))), this.config.saturationOverlayHue){

                    protected void method_25346() {
                        SaturationColorScreen.this.config.saturationOverlayHue = (float)this.field_22753;
                        this.method_25355((class_2561)class_2561.method_43470((String)("Hue: " + String.format("%.2f", Float.valueOf(SaturationColorScreen.this.config.saturationOverlayHue)))));
                    }

                    protected void method_25344() {
                        SaturationColorScreen.this.config.saturationOverlayHue = (float)this.field_22753;
                    }
                });
                System.out.println("DEBUG: Hue slider created");
                System.out.println("DEBUG: Creating gamma slider...");
                this.gammaSlider = (class_357)this.method_37063((class_364)new class_357(centerX - 100, startY + 30, 200, 20, (class_2561)class_2561.method_43470((String)("Gamma: " + String.format("%.2f", Float.valueOf(this.config.saturationOverlayGamma)))), (double)this.config.saturationOverlayGamma / 2.0){

                    protected void method_25346() {
                        SaturationColorScreen.this.config.saturationOverlayGamma = (float)(this.field_22753 * 2.0);
                        this.method_25355((class_2561)class_2561.method_43470((String)("Gamma: " + String.format("%.2f", Float.valueOf(SaturationColorScreen.this.config.saturationOverlayGamma)))));
                    }

                    protected void method_25344() {
                        SaturationColorScreen.this.config.saturationOverlayGamma = (float)(this.field_22753 * 2.0);
                    }
                });
                System.out.println("DEBUG: Gamma slider created");
            } else {
                System.out.println("DEBUG: Creating RGB sliders...");
                System.out.println("DEBUG: Creating red slider...");
                this.redSlider = (class_357)this.method_37063((class_364)new class_357(centerX - 100, startY, 200, 20, (class_2561)class_2561.method_43470((String)("Red: " + this.config.saturationOverlayRed)), (double)this.config.saturationOverlayRed / 255.0){

                    protected void method_25346() {
                        SaturationColorScreen.this.config.saturationOverlayRed = (int)(this.field_22753 * 255.0);
                        this.method_25355((class_2561)class_2561.method_43470((String)("Red: " + SaturationColorScreen.this.config.saturationOverlayRed)));
                    }

                    protected void method_25344() {
                        SaturationColorScreen.this.config.saturationOverlayRed = (int)(this.field_22753 * 255.0);
                    }
                });
                System.out.println("DEBUG: Red slider created");
                System.out.println("DEBUG: Creating green slider...");
                this.greenSlider = (class_357)this.method_37063((class_364)new class_357(centerX - 100, startY + 30, 200, 20, (class_2561)class_2561.method_43470((String)("Green: " + this.config.saturationOverlayGreen)), (double)this.config.saturationOverlayGreen / 255.0){

                    protected void method_25346() {
                        SaturationColorScreen.this.config.saturationOverlayGreen = (int)(this.field_22753 * 255.0);
                        this.method_25355((class_2561)class_2561.method_43470((String)("Green: " + SaturationColorScreen.this.config.saturationOverlayGreen)));
                    }

                    protected void method_25344() {
                        SaturationColorScreen.this.config.saturationOverlayGreen = (int)(this.field_22753 * 255.0);
                    }
                });
                System.out.println("DEBUG: Green slider created");
                System.out.println("DEBUG: Creating blue slider...");
                this.blueSlider = (class_357)this.method_37063((class_364)new class_357(centerX - 100, startY + 60, 200, 20, (class_2561)class_2561.method_43470((String)("Blue: " + this.config.saturationOverlayBlue)), (double)this.config.saturationOverlayBlue / 255.0){

                    protected void method_25346() {
                        SaturationColorScreen.this.config.saturationOverlayBlue = (int)(this.field_22753 * 255.0);
                        this.method_25355((class_2561)class_2561.method_43470((String)("Blue: " + SaturationColorScreen.this.config.saturationOverlayBlue)));
                    }

                    protected void method_25344() {
                        SaturationColorScreen.this.config.saturationOverlayBlue = (int)(this.field_22753 * 255.0);
                    }
                });
                System.out.println("DEBUG: Blue slider created");
            }
            System.out.println("DEBUG: buildSliders() completed successfully");
        }
        catch (Exception e) {
            System.err.println("ERROR: Exception in buildSliders(): " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    private void rebuildSliders() {
        if (this.redSlider != null) {
            this.method_37066((class_364)this.redSlider);
        }
        if (this.greenSlider != null) {
            this.method_37066((class_364)this.greenSlider);
        }
        if (this.blueSlider != null) {
            this.method_37066((class_364)this.blueSlider);
        }
        if (this.hueSlider != null) {
            this.method_37066((class_364)this.hueSlider);
        }
        if (this.gammaSlider != null) {
            this.method_37066((class_364)this.gammaSlider);
        }
        this.buildSliders();
    }

    private void resetToDefaults() {
        this.config.saturationOverlayRed = 255;
        this.config.saturationOverlayGreen = 255;
        this.config.saturationOverlayBlue = 255;
        this.config.saturationOverlayHue = 0.0f;
        this.config.saturationOverlayGamma = 1.0f;
        this.config.useSaturationHSLMode = false;
        this.method_37067();
        this.method_25426();
    }

    private void saveConfig() {
        AutoConfig.getConfigHolder(ModConfig.class).save();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        int centerX = this.field_22789 / 2;
        int previewY = this.field_22790 / 4 + 120;
        int color = this.getPreviewColor();
        context.method_25294(centerX - 16, previewY, centerX + 16, previewY + 32, -8355712);
        context.method_25294(centerX - 16, previewY, centerX, previewY + 16, -5197648);
        context.method_25294(centerX, previewY + 16, centerX + 16, previewY + 32, -5197648);
        context.method_25294(centerX - 16, previewY, centerX + 16, previewY + 32, color);
        context.method_25300(this.field_22793, "Preview", centerX, previewY + 32 + 10, 0xFFFFFF);
    }

    private int getPreviewColor() {
        if (this.config.useSaturationHSLMode) {
            float b;
            float g;
            float r;
            float hue = this.config.saturationOverlayHue;
            float saturation = 1.0f;
            float lightness = this.config.saturationOverlayGamma * 0.5f;
            hue = class_3532.method_15363((float)hue, (float)0.0f, (float)1.0f);
            lightness = class_3532.method_15363((float)lightness, (float)0.0f, (float)1.0f);
            float c = (1.0f - Math.abs(2.0f * lightness - 1.0f)) * saturation;
            float x = c * (1.0f - Math.abs(hue * 6.0f % 2.0f - 1.0f));
            float m = lightness - c / 2.0f;
            if (hue < 0.16666667f) {
                r = c;
                g = x;
                b = 0.0f;
            } else if (hue < 0.33333334f) {
                r = x;
                g = c;
                b = 0.0f;
            } else if (hue < 0.5f) {
                r = 0.0f;
                g = c;
                b = x;
            } else if (hue < 0.6666667f) {
                r = 0.0f;
                g = x;
                b = c;
            } else if (hue < 0.8333333f) {
                r = x;
                g = 0.0f;
                b = c;
            } else {
                r = c;
                g = 0.0f;
                b = x;
            }
            int red = (int)((r + m) * 255.0f);
            int green = (int)((g + m) * 255.0f);
            int blue = (int)((b + m) * 255.0f);
            return class_5253.class_5254.method_27764((int)255, (int)red, (int)green, (int)blue);
        }
        return class_5253.class_5254.method_27764((int)255, (int)this.config.saturationOverlayRed, (int)this.config.saturationOverlayGreen, (int)this.config.saturationOverlayBlue);
    }

    public void method_25419() {
        this.saveConfig();
        super.method_25419();
    }
}

