/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5253;
import net.minecraft.class_5676;
import squeek.appleskin.ModConfig;
import squeek.appleskin.client.BannanaCommand;
import squeek.appleskin.helpers.TextureHelper;

public class BananaCommandsScreen
extends class_437 {
    private final class_437 parent;
    private ModConfig config;
    private class_342 presetNameField;
    private class_357 redSlider;
    private class_357 greenSlider;
    private class_357 blueSlider;
    private class_357 hueSlider;
    private class_357 gammaSlider;
    private class_357 autoShiftSecondsSlider;
    private class_5676<String> shiftDirectionButton;
    private float autoShiftSeconds = 0.25f;
    private class_5676<Integer> drumstickIndexButton;
    private class_357 dsRedSlider;
    private class_357 dsGreenSlider;
    private class_357 dsBlueSlider;
    private float dsRVal = 0.0f;
    private float dsGVal = 0.0f;
    private float dsBVal = 0.0f;
    private String presetDraftName = "";
    private boolean presetFieldFocused = false;
    private final List<ContentEntry> contentEntries = new ArrayList<ContentEntry>();
    private float scrollOffset = 0.0f;
    private int contentHeight = 0;
    private boolean lastModeHsl = false;
    private int previewBaseY = 0;
    private final int contentTop = 8;

    public BananaCommandsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"BananaSkin Controls"));
        this.parent = parent;
        this.config = ModConfig.INSTANCE;
    }

    protected void method_25426() {
        super.method_25426();
        this.lastModeHsl = this.config.useSaturationHSLMode;
        this.buildContent();
    }

    private <T extends class_339> T addContentWidget(T w, int baseY) {
        this.contentEntries.add(new ContentEntry(w, baseY));
        w.method_46419(baseY - (int)this.scrollOffset);
        return (T)((class_339)this.method_37063((class_364)w));
    }

    private void clearContentWidgets() {
        for (ContentEntry e : this.contentEntries) {
            this.method_37066((class_364)e.widget);
        }
        this.contentEntries.clear();
    }

    private void buildSliders(int cx, int y) {
        if (this.config.useSaturationHSLMode) {
            this.hueSlider = this.addContentWidget(new class_357(cx - 150, y, 300, 20, (class_2561)class_2561.method_43470((String)String.format("Hue: %.2f", Float.valueOf(this.config.saturationOverlayHue))), this.config.saturationOverlayHue){

                protected void method_25346() {
                    BananaCommandsScreen.this.config.saturationOverlayHue = (float)this.field_22753;
                    this.method_25355((class_2561)class_2561.method_43470((String)String.format("Hue: %.2f", Float.valueOf(BananaCommandsScreen.this.config.saturationOverlayHue))));
                }

                protected void method_25344() {
                    BananaCommandsScreen.this.config.saturationOverlayHue = (float)this.field_22753;
                }
            }, y);
            this.gammaSlider = this.addContentWidget(new class_357(cx - 150, y += 24, 300, 20, (class_2561)class_2561.method_43470((String)String.format("Gamma: %.2f", Float.valueOf(this.config.saturationOverlayGamma))), (double)this.config.saturationOverlayGamma / 2.0){

                protected void method_25346() {
                    BananaCommandsScreen.this.config.saturationOverlayGamma = (float)(this.field_22753 * 2.0);
                    this.method_25355((class_2561)class_2561.method_43470((String)String.format("Gamma: %.2f", Float.valueOf(BananaCommandsScreen.this.config.saturationOverlayGamma))));
                }

                protected void method_25344() {
                    BananaCommandsScreen.this.config.saturationOverlayGamma = (float)(this.field_22753 * 2.0);
                }
            }, y);
        } else {
            this.redSlider = this.addContentWidget(new class_357(cx - 150, y, 300, 20, (class_2561)class_2561.method_43470((String)("Red: " + this.config.saturationOverlayRed)), (double)this.config.saturationOverlayRed / 255.0){

                protected void method_25346() {
                    BananaCommandsScreen.this.config.saturationOverlayRed = (int)(this.field_22753 * 255.0);
                    this.method_25355((class_2561)class_2561.method_43470((String)("Red: " + BananaCommandsScreen.this.config.saturationOverlayRed)));
                }

                protected void method_25344() {
                    BananaCommandsScreen.this.config.saturationOverlayRed = (int)(this.field_22753 * 255.0);
                }
            }, y);
            this.greenSlider = this.addContentWidget(new class_357(cx - 150, y += 24, 300, 20, (class_2561)class_2561.method_43470((String)("Green: " + this.config.saturationOverlayGreen)), (double)this.config.saturationOverlayGreen / 255.0){

                protected void method_25346() {
                    BananaCommandsScreen.this.config.saturationOverlayGreen = (int)(this.field_22753 * 255.0);
                    this.method_25355((class_2561)class_2561.method_43470((String)("Green: " + BananaCommandsScreen.this.config.saturationOverlayGreen)));
                }

                protected void method_25344() {
                    BananaCommandsScreen.this.config.saturationOverlayGreen = (int)(this.field_22753 * 255.0);
                }
            }, y);
            this.blueSlider = this.addContentWidget(new class_357(cx - 150, y += 24, 300, 20, (class_2561)class_2561.method_43470((String)("Blue: " + this.config.saturationOverlayBlue)), (double)this.config.saturationOverlayBlue / 255.0){

                protected void method_25346() {
                    BananaCommandsScreen.this.config.saturationOverlayBlue = (int)(this.field_22753 * 255.0);
                    this.method_25355((class_2561)class_2561.method_43470((String)("Blue: " + BananaCommandsScreen.this.config.saturationOverlayBlue)));
                }

                protected void method_25344() {
                    BananaCommandsScreen.this.config.saturationOverlayBlue = (int)(this.field_22753 * 255.0);
                }
            }, y);
        }
    }

    private void buildContent() {
        this.clearContentWidgets();
        int cx = this.field_22789 / 2;
        int y = 8;
        this.addContentWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.config.useSaturationHSLMode ? "Mode: HSL" : "Mode: RGB")), b -> {
            this.lastModeHsl = this.config.useSaturationHSLMode = !this.config.useSaturationHSLMode;
            b.method_25355((class_2561)class_2561.method_43470((String)(this.config.useSaturationHSLMode ? "Mode: HSL" : "Mode: RGB")));
            this.buildContent();
        }).method_46434(cx - 60, y, 120, 20).method_46431(), y);
        this.buildSliders(cx, y += 24);
        this.previewBaseY = y += this.config.useSaturationHSLMode ? 56 : 88;
        this.addContentWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Random Single"), b -> {
            BannanaCommand.randomSingleColor();
            AutoConfig.getConfigHolder(ModConfig.class).save();
            this.buildContent();
        }).method_46434(cx - 150, y += 25, 120, 20).method_46431(), y);
        this.addContentWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Random Per-Drumstick"), b -> {
            BannanaCommand.randomPerDrumstick();
            AutoConfig.getConfigHolder(ModConfig.class).save();
            this.buildContent();
        }).method_46434(cx + 30, y, 180, 20).method_46431(), y);
        this.shiftDirectionButton = this.addContentWidget(class_5676.method_32606(s -> class_2561.method_43470((String)s)).method_32624((Object[])new String[]{"left", "right"}).method_32619((Object)"left").method_35723(cx - 150, y += 24, 80, 20, (class_2561)class_2561.method_43470((String)"Direction")), y);
        this.autoShiftSecondsSlider = this.addContentWidget(new class_357(cx - 60, y, 120, 20, (class_2561)class_2561.method_43470((String)"Secs: 0.25"), 0.25){

            protected void method_25346() {
                BananaCommandsScreen.this.autoShiftSeconds = (float)(0.05 + this.field_22753 * 9.95);
                this.method_25355((class_2561)class_2561.method_43470((String)String.format("Secs: %.2f", Float.valueOf(BananaCommandsScreen.this.autoShiftSeconds))));
            }

            protected void method_25344() {
                BananaCommandsScreen.this.autoShiftSeconds = (float)(0.05 + this.field_22753 * 9.95);
            }
        }, y);
        this.addContentWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Shift Once"), b -> BannanaCommand.shiftOnce((String)this.shiftDirectionButton.method_32603())).method_46434(cx + 70, y, 90, 20).method_46431(), y);
        this.addContentWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Start Auto Shift"), b -> BannanaCommand.startAutoShift((String)this.shiftDirectionButton.method_32603(), this.autoShiftSeconds)).method_46434(cx - 150, y += 24, 130, 20).method_46431(), y);
        this.addContentWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Stop Auto Shift"), b -> BannanaCommand.stopAutoShift()).method_46434(cx - 10, y, 120, 20).method_46431(), y);
        this.addContentWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Undo"), b -> {
            BannanaCommand.undo();
            this.buildContent();
        }).method_46434(cx - 150, y += 24, 70, 20).method_46431(), y);
        this.addContentWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Redo"), b -> {
            BannanaCommand.redo();
            this.buildContent();
        }).method_46434(cx - 70, y, 70, 20).method_46431(), y);
        this.drumstickIndexButton = this.addContentWidget(class_5676.method_32606(i -> class_2561.method_43470((String)("Drumstick " + i))).method_32624((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).method_32619((Object)1).method_35723(cx - 150, y += 24, 110, 20, (class_2561)class_2561.method_43470((String)"Index")), y);
        this.addContentWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear"), b -> {
            this.ensureDrumstickArray();
            int idx = (Integer)this.drumstickIndexButton.method_32603() - 1;
            ModConfig.INSTANCE.drumstickColors[idx * 3] = -1;
            ModConfig.INSTANCE.drumstickColors[idx * 3 + 1] = -1;
            ModConfig.INSTANCE.drumstickColors[idx * 3 + 2] = -1;
            AutoConfig.getConfigHolder(ModConfig.class).save();
        }).method_46434(cx - 36, y, 60, 20).method_46431(), y);
        this.addContentWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Copy Overlay"), b -> {
            int bv;
            int g;
            int r;
            int idx = (Integer)this.drumstickIndexButton.method_32603() - 1;
            if (this.config.useSaturationHSLMode) {
                int color = this.getPreviewColor();
                r = class_5253.class_5254.method_27765((int)color);
                g = class_5253.class_5254.method_27766((int)color);
                bv = class_5253.class_5254.method_27767((int)color);
            } else {
                r = this.config.saturationOverlayRed;
                g = this.config.saturationOverlayGreen;
                bv = this.config.saturationOverlayBlue;
            }
            BannanaCommand.setDrumstickColorRGB(idx, r, g, bv);
        }).method_46434(cx + 30, y, 150, 20).method_46431(), y);
        this.dsRedSlider = this.addContentWidget(new class_357(cx - 150, y += 24, 300, 20, (class_2561)class_2561.method_43470((String)"Drumstick R"), 0.0){

            protected void method_25346() {
                BananaCommandsScreen.this.dsRVal = (float)this.field_22753;
                this.method_25355((class_2561)class_2561.method_43470((String)("Drumstick R: " + (int)(BananaCommandsScreen.this.dsRVal * 255.0f))));
            }

            protected void method_25344() {
                BananaCommandsScreen.this.dsRVal = (float)this.field_22753;
            }
        }, y);
        this.dsGreenSlider = this.addContentWidget(new class_357(cx - 150, y += 24, 300, 20, (class_2561)class_2561.method_43470((String)"Drumstick G"), 0.0){

            protected void method_25346() {
                BananaCommandsScreen.this.dsGVal = (float)this.field_22753;
                this.method_25355((class_2561)class_2561.method_43470((String)("Drumstick G: " + (int)(BananaCommandsScreen.this.dsGVal * 255.0f))));
            }

            protected void method_25344() {
                BananaCommandsScreen.this.dsGVal = (float)this.field_22753;
            }
        }, y);
        this.dsBlueSlider = this.addContentWidget(new class_357(cx - 150, y += 24, 300, 20, (class_2561)class_2561.method_43470((String)"Drumstick B"), 0.0){

            protected void method_25346() {
                BananaCommandsScreen.this.dsBVal = (float)this.field_22753;
                this.method_25355((class_2561)class_2561.method_43470((String)("Drumstick B: " + (int)(BananaCommandsScreen.this.dsBVal * 255.0f))));
            }

            protected void method_25344() {
                BananaCommandsScreen.this.dsBVal = (float)this.field_22753;
            }
        }, y);
        this.addContentWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Set Drumstick Color"), b -> {
            int idx = (Integer)this.drumstickIndexButton.method_32603() - 1;
            int r = (int)(this.dsRVal * 255.0f);
            int g = (int)(this.dsGVal * 255.0f);
            int bv = (int)(this.dsBVal * 255.0f);
            BannanaCommand.setDrumstickColorRGB(idx, r, g, bv);
        }).method_46434(cx - 100, y += 24, 200, 20).method_46431(), y);
        this.presetNameField = new class_342(this.field_22793, cx - 150, y += 24, 140, 20, (class_2561)class_2561.method_43470((String)"Preset name"));
        if (!this.presetDraftName.isEmpty()) {
            this.presetNameField.method_1852(this.presetDraftName);
        }
        this.method_25429((class_364)this.presetNameField);
        this.addContentWidget(this.presetNameField, y);
        this.addContentWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> {
            String name = this.presetNameField.method_1882().trim();
            if (!name.isEmpty()) {
                BannanaCommand.savePresetByName(name);
            }
            this.presetDraftName = this.presetNameField.method_1882();
            this.presetFieldFocused = this.presetNameField.method_25370();
            this.buildContent();
        }).method_46434(cx - 6, y, 50, 20).method_46431(), y);
        this.addContentWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Load"), b -> {
            String name = this.presetNameField.method_1882().trim();
            if (!name.isEmpty()) {
                BannanaCommand.loadPresetByName(name);
            }
        }).method_46434(cx + 46, y, 50, 20).method_46431(), y);
        this.addContentWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Delete"), b -> {
            String name = this.presetNameField.method_1882().trim();
            if (!name.isEmpty()) {
                BannanaCommand.deletePresetByName(name);
            }
            this.presetDraftName = this.presetNameField.method_1882();
            this.presetFieldFocused = this.presetNameField.method_25370();
            this.buildContent();
        }).method_46434(cx + 98, y, 60, 20).method_46431(), y);
        y += 24;
        int x = cx - 150;
        for (Map.Entry<String, BannanaCommand.Preset> e : BannanaCommand.getPresets().entrySet()) {
            String preset = e.getKey();
            this.addContentWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)preset), b -> this.presetNameField.method_1852(preset)).method_46434(x, y, 90, 20).method_46431(), y);
            if ((x += 94) <= cx + 120) continue;
            x = cx - 150;
            y += 24;
        }
        if (x != cx - 150) {
            y += 24;
        }
        this.addContentWidget(class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset to Default"), b -> {
            BannanaCommand.resetToDefaults();
            this.buildContent();
        }).method_46434(cx - 150, y, 130, 20).method_46431(), y);
        this.addContentWidget(class_4185.method_46430((class_2561)class_5244.field_24334, b -> {
            AutoConfig.getConfigHolder(ModConfig.class).save();
            class_310.method_1551().method_1507(this.parent);
        }).method_46434(cx + 20, y, 130, 20).method_46431(), y);
        this.contentHeight = (y += 24) - 8 + 16;
        this.clampScroll();
        this.repositionContentWidgets();
    }

    private void ensureDrumstickArray() {
        if (ModConfig.INSTANCE.drumstickColors == null || ModConfig.INSTANCE.drumstickColors.length != 30) {
            ModConfig.INSTANCE.drumstickColors = new int[30];
            for (int i = 0; i < 10; ++i) {
                ModConfig.INSTANCE.drumstickColors[i * 3] = -1;
                ModConfig.INSTANCE.drumstickColors[i * 3 + 1] = -1;
                ModConfig.INSTANCE.drumstickColors[i * 3 + 2] = -1;
            }
        }
    }

    private void repositionContentWidgets() {
        for (ContentEntry e : this.contentEntries) {
            e.widget.method_46419(e.baseY - (int)this.scrollOffset);
        }
        if (this.presetNameField != null) {
            this.presetNameField.method_1852(this.presetDraftName);
            if (this.presetFieldFocused) {
                this.presetNameField.method_25365(true);
            }
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        double amount = verticalAmount;
        this.scrollOffset = (float)((double)this.scrollOffset - amount * 12.0);
        this.clampScroll();
        this.repositionContentWidgets();
        return true;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        int cx = this.field_22789 / 2;
        int previewY = this.previewBaseY - (int)this.scrollOffset;
        int iconSize = 9;
        int startX = cx + 50;
        for (int i = 0; i < 10; ++i) {
            float b;
            float g;
            float r;
            int x = startX - i * 8 - 9;
            int y = previewY;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            context.method_52706(TextureHelper.getFoodTexture(false, TextureHelper.FoodType.EMPTY), x, y, iconSize, iconSize);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.method_25302(TextureHelper.MOD_ICONS, x, y, 0, 0, iconSize, iconSize);
            int[] colors = ModConfig.INSTANCE.drumstickColors;
            boolean usedCustom = false;
            if (colors != null && colors.length == 30) {
                int rr = colors[i * 3];
                int gg = colors[i * 3 + 1];
                int bb = colors[i * 3 + 2];
                if (rr >= 0 && gg >= 0 && bb >= 0) {
                    r = (float)rr / 255.0f;
                    g = (float)gg / 255.0f;
                    b = (float)bb / 255.0f;
                    usedCustom = true;
                    RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
                }
            }
            if (!usedCustom) {
                if (this.config.useSaturationHSLMode) {
                    int c = this.getPreviewColor();
                    r = (float)class_5253.class_5254.method_27765((int)c) / 255.0f;
                    g = (float)class_5253.class_5254.method_27766((int)c) / 255.0f;
                    b = (float)class_5253.class_5254.method_27767((int)c) / 255.0f;
                } else {
                    r = (float)this.config.saturationOverlayRed / 255.0f;
                    g = (float)this.config.saturationOverlayGreen / 255.0f;
                    b = (float)this.config.saturationOverlayBlue / 255.0f;
                }
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
            }
            context.method_25302(TextureHelper.MOD_ICONS, x, y, 0, 0, iconSize, iconSize);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.method_25300(this.field_22793, "Preview", cx, previewY + iconSize + 6, 0xFFFFFF);
    }

    private int getPreviewColor() {
        if (this.config.useSaturationHSLMode) {
            float b;
            float g;
            float r;
            float hue = Math.max(0.0f, Math.min(1.0f, this.config.saturationOverlayHue));
            float lightness = Math.max(0.0f, Math.min(1.0f, this.config.saturationOverlayGamma * 0.5f));
            float c = 1.0f - Math.abs(2.0f * lightness - 1.0f);
            float x = c * (1.0f - Math.abs(hue * 6.0f % 2.0f - 1.0f));
            float m = lightness - c / 2.0f;
            if (hue < 0.16666667f) {
                r = c;
                g = x;
                b = 0.0f;
            } else if (hue < 0.33333334f) {
                r = x;
                g = c;
                b = 0.0f;
            } else if (hue < 0.5f) {
                r = 0.0f;
                g = c;
                b = x;
            } else if (hue < 0.6666667f) {
                r = 0.0f;
                g = x;
                b = c;
            } else if (hue < 0.8333333f) {
                r = x;
                g = 0.0f;
                b = c;
            } else {
                r = c;
                g = 0.0f;
                b = x;
            }
            int red = (int)((r + m) * 255.0f);
            int green = (int)((g + m) * 255.0f);
            int blue = (int)((b + m) * 255.0f);
            return class_5253.class_5254.method_27764((int)255, (int)red, (int)green, (int)blue);
        }
        return class_5253.class_5254.method_27764((int)255, (int)this.config.saturationOverlayRed, (int)this.config.saturationOverlayGreen, (int)this.config.saturationOverlayBlue);
    }

    public void method_25419() {
        AutoConfig.getConfigHolder(ModConfig.class).save();
        super.method_25419();
    }

    public void method_25393() {
        super.method_25393();
        if (this.lastModeHsl != this.config.useSaturationHSLMode) {
            this.lastModeHsl = this.config.useSaturationHSLMode;
            this.buildContent();
        }
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.buildContent();
    }

    private void clampScroll() {
        int viewport = this.field_22790 - 60;
        if (this.contentHeight <= viewport) {
            this.scrollOffset = 0.0f;
        } else {
            if (this.scrollOffset < 0.0f) {
                this.scrollOffset = 0.0f;
            }
            if (this.scrollOffset > (float)(this.contentHeight - viewport)) {
                this.scrollOffset = this.contentHeight - viewport;
            }
        }
    }

    private static class ContentEntry {
        final class_339 widget;
        final int baseY;

        ContentEntry(class_339 widget, int baseY) {
            this.widget = widget;
            this.baseY = baseY;
        }
    }
}

