/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import squeek.appleskin.ModConfig;

public class BannanaCommand {
    private static final File PRESET_FILE = new File("appleskin_saturation_presets.json");
    private static final Gson GSON = new Gson();
    private static final Type PRESET_MAP_TYPE = new TypeToken<Map<String, Preset>>(){}.getType();
    private static Map<String, Preset> presets = new HashMap<String, Preset>();
    private static ScheduledExecutorService shiftScheduler;
    private static ScheduledFuture<?> shiftTask;
    private static String shiftDirection;
    private static final Stack<Preset> undoStack;
    private static final Stack<Preset> redoStack;
    private static boolean shiftPaused;

    private static void savePresetsToFile() {
        try (FileWriter writer = new FileWriter(PRESET_FILE);){
            GSON.toJson(presets, PRESET_MAP_TYPE, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadPresetsFromFile() {
        if (!PRESET_FILE.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(PRESET_FILE);){
            presets = (Map)GSON.fromJson((Reader)reader, PRESET_MAP_TYPE);
            if (presets == null) {
                presets = new HashMap<String, Preset>();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean allDrumstickColorsSame() {
        int[] colors = ModConfig.INSTANCE.drumstickColors;
        if (colors == null || colors.length != 30) {
            return false;
        }
        int r0 = colors[0];
        int g0 = colors[1];
        int b0 = colors[2];
        for (int i = 1; i < 10; ++i) {
            int r = colors[i * 3];
            int g = colors[i * 3 + 1];
            int b = colors[i * 3 + 2];
            if (r == r0 && g == g0 && b == b0) continue;
            return false;
        }
        return true;
    }

    private static int shiftDrumsticks(CommandContext<FabricClientCommandSource> context, boolean auto, float seconds) {
        String dir = StringArgumentType.getString(context, (String)"direction").toLowerCase();
        int direction = 0;
        if ("left".startsWith(dir)) {
            direction = 1;
        } else if ("right".startsWith(dir)) {
            direction = -1;
        }
        if (direction == 0) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Invalid direction. Use any abbreviation of left or right."));
            return 0;
        }
        if (auto) {
            BannanaCommand.stopShiftTask();
            shiftDirection = dir;
            int dirFinal = direction;
            shiftPaused = false;
            shiftTask = shiftScheduler.scheduleAtFixedRate(() -> {
                if (BannanaCommand.allDrumstickColorsSame()) {
                    shiftPaused = true;
                    return;
                }
                shiftPaused = false;
                BannanaCommand.shiftDrumstickColors(dirFinal);
                BannanaCommand.saveConfig();
            }, 0L, (long)(seconds * 1000.0f), TimeUnit.MILLISECONDS);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Started shifting drumstick colors " + (direction == 1 ? "left" : "right") + " every " + seconds + " seconds.")));
        } else {
            BannanaCommand.shiftDrumstickColors(direction);
            BannanaCommand.saveConfig();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Shifted drumstick colors " + (direction == 1 ? "left" : "right") + ".")));
        }
        return 1;
    }

    private static void resumeShiftIfPaused() {
        if (shiftPaused && shiftTask != null && !BannanaCommand.allDrumstickColorsSame()) {
            shiftPaused = false;
        }
    }

    private static int stopShiftDrumsticks(CommandContext<FabricClientCommandSource> context) {
        BannanaCommand.stopShiftTask();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Stopped auto-shifting drumstick colors."));
        return 1;
    }

    private static void stopShiftTask() {
        if (shiftTask != null && !shiftTask.isCancelled()) {
            shiftTask.cancel(true);
            shiftTask = null;
        }
    }

    private static void shiftDrumstickColors(int direction) {
        int[] colors = ModConfig.INSTANCE.drumstickColors;
        if (colors == null || colors.length != 30) {
            return;
        }
        int[] newColors = new int[30];
        for (int i = 0; i < 10; ++i) {
            int from = direction == 1 ? (i + 9) % 10 : (i + 1) % 10;
            newColors[i * 3] = colors[from * 3];
            newColors[i * 3 + 1] = colors[from * 3 + 1];
            newColors[i * 3 + 2] = colors[from * 3 + 2];
        }
        System.arraycopy(newColors, 0, colors, 0, 30);
    }

    private static void pushUndo() {
        undoStack.push(new Preset(ModConfig.INSTANCE));
        redoStack.clear();
    }

    private static int undo(CommandContext<FabricClientCommandSource> context) {
        if (undoStack.isEmpty()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Nothing to undo.").method_27692(class_124.field_1061));
            return 0;
        }
        redoStack.push(new Preset(ModConfig.INSTANCE));
        Preset prev = undoStack.pop();
        prev.apply(ModConfig.INSTANCE);
        BannanaCommand.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Undo successful.").method_27692(class_124.field_1060));
        return 1;
    }

    private static int redo(CommandContext<FabricClientCommandSource> context) {
        if (redoStack.isEmpty()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Nothing to redo.").method_27692(class_124.field_1061));
            return 0;
        }
        undoStack.push(new Preset(ModConfig.INSTANCE));
        Preset next = redoStack.pop();
        next.apply(ModConfig.INSTANCE);
        BannanaCommand.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Redo successful.").method_27692(class_124.field_1060));
        return 1;
    }

    private static int loadRandomPreset(CommandContext<FabricClientCommandSource> context) {
        if (presets.isEmpty()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"No presets saved.").method_27692(class_124.field_1061));
            return 0;
        }
        String[] keys = presets.keySet().toArray(new String[0]);
        String randomName = keys[new Random().nextInt(keys.length)];
        Preset preset = presets.get(randomName);
        if (preset == null) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Failed to load random preset.").method_27692(class_124.field_1061));
            return 0;
        }
        BannanaCommand.pushUndo();
        preset.apply(ModConfig.INSTANCE);
        BannanaCommand.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Loaded random preset: " + randomName)).method_27692(class_124.field_1060));
        return 1;
    }

    private static int randomSingleColor(CommandContext<FabricClientCommandSource> context) {
        BannanaCommand.pushUndo();
        Random rand = new Random();
        boolean useHSL = rand.nextBoolean();
        if (useHSL) {
            float hue = rand.nextFloat();
            float gamma = 0.5f + rand.nextFloat() * 1.5f;
            ModConfig.INSTANCE.saturationOverlayHue = hue;
            ModConfig.INSTANCE.saturationOverlayGamma = gamma;
            ModConfig.INSTANCE.useSaturationHSLMode = true;
            ModConfig.INSTANCE.drumstickColors = null;
            BannanaCommand.saveConfig();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Set random HSL: Hue=%.2f Gamma=%.2f", Float.valueOf(hue), Float.valueOf(gamma))).method_27692(class_124.field_1076));
        } else {
            int r = rand.nextInt(256);
            int g = rand.nextInt(256);
            int b = rand.nextInt(256);
            ModConfig.INSTANCE.saturationOverlayRed = r;
            ModConfig.INSTANCE.saturationOverlayGreen = g;
            ModConfig.INSTANCE.saturationOverlayBlue = b;
            ModConfig.INSTANCE.useSaturationHSLMode = false;
            ModConfig.INSTANCE.drumstickColors = null;
            BannanaCommand.saveConfig();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Set random RGB: R=%d G=%d B=%d", r, g, b)).method_27692(class_124.field_1075));
        }
        BannanaCommand.resumeShiftIfPaused();
        return 1;
    }

    private static int randomPerDrumstick(CommandContext<FabricClientCommandSource> context) {
        BannanaCommand.pushUndo();
        Random rand = new Random();
        boolean useHSL = rand.nextBoolean();
        int[] drumstickColors = new int[30];
        if (useHSL) {
            ModConfig.INSTANCE.useSaturationHSLMode = true;
            ModConfig.INSTANCE.saturationOverlayHue = rand.nextFloat();
            ModConfig.INSTANCE.saturationOverlayGamma = 0.5f + rand.nextFloat() * 1.5f;
            for (int i = 0; i < 10; ++i) {
                float b;
                float g;
                float r;
                float hue = rand.nextFloat();
                float gamma = 0.5f + rand.nextFloat() * 1.5f;
                float saturation = 1.0f;
                float lightness = gamma * 0.5f;
                float c = (1.0f - Math.abs(2.0f * lightness - 1.0f)) * saturation;
                float x = c * (1.0f - Math.abs(hue * 6.0f % 2.0f - 1.0f));
                float m = lightness - c / 2.0f;
                if (hue < 0.16666667f) {
                    r = c;
                    g = x;
                    b = 0.0f;
                } else if (hue < 0.33333334f) {
                    r = x;
                    g = c;
                    b = 0.0f;
                } else if (hue < 0.5f) {
                    r = 0.0f;
                    g = c;
                    b = x;
                } else if (hue < 0.6666667f) {
                    r = 0.0f;
                    g = x;
                    b = c;
                } else if (hue < 0.8333333f) {
                    r = x;
                    g = 0.0f;
                    b = c;
                } else {
                    r = c;
                    g = 0.0f;
                    b = x;
                }
                drumstickColors[i * 3] = (int)((r + m) * 255.0f);
                drumstickColors[i * 3 + 1] = (int)((g + m) * 255.0f);
                drumstickColors[i * 3 + 2] = (int)((b + m) * 255.0f);
            }
            ModConfig.INSTANCE.drumstickColors = drumstickColors;
            BannanaCommand.saveConfig();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Set random HSL color for each drumstick").method_27692(class_124.field_1076));
        } else {
            ModConfig.INSTANCE.useSaturationHSLMode = false;
            ModConfig.INSTANCE.saturationOverlayRed = rand.nextInt(256);
            ModConfig.INSTANCE.saturationOverlayGreen = rand.nextInt(256);
            ModConfig.INSTANCE.saturationOverlayBlue = rand.nextInt(256);
            for (int i = 0; i < 10; ++i) {
                drumstickColors[i * 3] = rand.nextInt(256);
                drumstickColors[i * 3 + 1] = rand.nextInt(256);
                drumstickColors[i * 3 + 2] = rand.nextInt(256);
            }
            ModConfig.INSTANCE.drumstickColors = drumstickColors;
            BannanaCommand.saveConfig();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Set random RGB color for each drumstick").method_27692(class_124.field_1075));
        }
        BannanaCommand.resumeShiftIfPaused();
        return 1;
    }

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"banana").executes(BannanaCommand::showHelp)).then(ClientCommandManager.literal((String)"rgb").then(ClientCommandManager.argument((String)"red", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).then(ClientCommandManager.argument((String)"green", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).then(ClientCommandManager.argument((String)"blue", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(BannanaCommand::setRGB)))))).then(ClientCommandManager.literal((String)"hsl").then(ClientCommandManager.argument((String)"hue", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).then(ClientCommandManager.argument((String)"gamma", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(BannanaCommand::setHSL))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"mode").then(ClientCommandManager.literal((String)"rgb").executes(BannanaCommand::setModeRGB))).then(ClientCommandManager.literal((String)"hsl").executes(BannanaCommand::setModeHSL)))).then(ClientCommandManager.literal((String)"reset").executes(BannanaCommand::resetToDefaults))).then(ClientCommandManager.literal((String)"show").executes(BannanaCommand::showCurrentValues))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"set").then(ClientCommandManager.literal((String)"rgb").then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).then(ClientCommandManager.argument((String)"red", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).then(ClientCommandManager.argument((String)"green", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).then(ClientCommandManager.argument((String)"blue", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(BannanaCommand::setDrumstickColorRGB))))))).then(ClientCommandManager.literal((String)"hsl").then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).then(ClientCommandManager.argument((String)"hue", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).then(ClientCommandManager.argument((String)"gamma", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(BannanaCommand::setDrumstickColorHSL))))))).then(ClientCommandManager.literal((String)"save").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> BannanaCommand.savePreset(StringArgumentType.getString((CommandContext)ctx, (String)"name"), (CommandContext<FabricClientCommandSource>)ctx))))).then(ClientCommandManager.literal((String)"load").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> BannanaCommand.loadPreset(StringArgumentType.getString((CommandContext)ctx, (String)"name"), (CommandContext<FabricClientCommandSource>)ctx))))).then(ClientCommandManager.literal((String)"delete").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> BannanaCommand.deletePreset(StringArgumentType.getString((CommandContext)ctx, (String)"name"), (CommandContext<FabricClientCommandSource>)ctx))))).then(ClientCommandManager.literal((String)"preset_list").executes(BannanaCommand::listPresets))).then(ClientCommandManager.literal((String)"preset_info").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(BannanaCommand::showPresetInfo)))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"shift").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"direction", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> {
            b.suggest("left");
            b.suggest("right");
            return b.buildFuture();
        }).executes(ctx -> BannanaCommand.shiftDrumsticks((CommandContext<FabricClientCommandSource>)ctx, false, 0.0f))).then(ClientCommandManager.literal((String)"on").then(ClientCommandManager.argument((String)"seconds", (ArgumentType)FloatArgumentType.floatArg((float)0.01f)).executes(ctx -> BannanaCommand.shiftDrumsticks((CommandContext<FabricClientCommandSource>)ctx, true, FloatArgumentType.getFloat((CommandContext)ctx, (String)"seconds"))))))).then(ClientCommandManager.literal((String)"off").executes(BannanaCommand::stopShiftDrumsticks)))).then(ClientCommandManager.literal((String)"undo").executes(BannanaCommand::undo))).then(ClientCommandManager.literal((String)"redo").executes(BannanaCommand::redo))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"random").executes(BannanaCommand::randomSingleColor)).then(ClientCommandManager.literal((String)"true").executes(BannanaCommand::randomPerDrumstick))).then(ClientCommandManager.literal((String)"preset").executes(BannanaCommand::loadRandomPreset))));
    }

    private static int showHelp(CommandContext<FabricClientCommandSource> context) {
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"=== Banana Saturation Color Commands ===").method_27692(class_124.field_1065));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"/banana rgb <red> <green> <blue> - Set RGB values (0-255)").method_27692(class_124.field_1054));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"/banana hsl <hue> <gamma> - Set HSL values (hue: 0.0-1.0, gamma: 0.0-2.0)").method_27692(class_124.field_1054));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"/banana mode rgb - Switch to RGB mode").method_27692(class_124.field_1054));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"/banana mode hsl - Switch to HSL mode").method_27692(class_124.field_1054));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"/banana reset - Reset to default values").method_27692(class_124.field_1054));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"/banana show - Show current values").method_27692(class_124.field_1054));
        return 1;
    }

    private static int setRGB(CommandContext<FabricClientCommandSource> context) {
        int red = IntegerArgumentType.getInteger(context, (String)"red");
        int green = IntegerArgumentType.getInteger(context, (String)"green");
        int blue = IntegerArgumentType.getInteger(context, (String)"blue");
        ModConfig.INSTANCE.saturationOverlayRed = red;
        ModConfig.INSTANCE.saturationOverlayGreen = green;
        ModConfig.INSTANCE.saturationOverlayBlue = blue;
        ModConfig.INSTANCE.useSaturationHSLMode = false;
        ModConfig.INSTANCE.drumstickColors = null;
        BannanaCommand.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Set RGB values: ").method_10852((class_2561)class_2561.method_43470((String)("R=" + red)).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(" G=" + green)).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)(" B=" + blue)).method_27692(class_124.field_1078)));
        return 1;
    }

    private static int setHSL(CommandContext<FabricClientCommandSource> context) {
        float hue = FloatArgumentType.getFloat(context, (String)"hue");
        float gamma = FloatArgumentType.getFloat(context, (String)"gamma");
        ModConfig.INSTANCE.saturationOverlayHue = hue;
        ModConfig.INSTANCE.saturationOverlayGamma = gamma;
        ModConfig.INSTANCE.useSaturationHSLMode = true;
        BannanaCommand.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Set HSL values: ").method_10852((class_2561)class_2561.method_43470((String)("Hue=" + String.format("%.2f", Float.valueOf(hue)))).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(" Gamma=" + String.format("%.2f", Float.valueOf(gamma)))).method_27692(class_124.field_1076)));
        return 1;
    }

    private static int setModeRGB(CommandContext<FabricClientCommandSource> context) {
        ModConfig.INSTANCE.useSaturationHSLMode = false;
        BannanaCommand.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Switched to RGB mode").method_27692(class_124.field_1060));
        BannanaCommand.showCurrentValues(context);
        return 1;
    }

    private static int setModeHSL(CommandContext<FabricClientCommandSource> context) {
        ModConfig.INSTANCE.useSaturationHSLMode = true;
        BannanaCommand.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Switched to HSL mode").method_27692(class_124.field_1060));
        BannanaCommand.showCurrentValues(context);
        return 1;
    }

    private static int resetToDefaults(CommandContext<FabricClientCommandSource> context) {
        ModConfig.INSTANCE.saturationOverlayRed = 0;
        ModConfig.INSTANCE.saturationOverlayGreen = 0;
        ModConfig.INSTANCE.saturationOverlayBlue = 0;
        ModConfig.INSTANCE.saturationOverlayHue = 0.0f;
        ModConfig.INSTANCE.saturationOverlayGamma = 1.0f;
        ModConfig.INSTANCE.useSaturationHSLMode = false;
        ModConfig.INSTANCE.drumstickColors = null;
        BannanaCommand.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Reset to default values (black, RGB mode)").method_27692(class_124.field_1060));
        return 1;
    }

    private static int showCurrentValues(CommandContext<FabricClientCommandSource> context) {
        int b;
        int g;
        int r;
        int i;
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"=== Current Saturation Color Settings ===").method_27692(class_124.field_1065));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Mode: " + (ModConfig.INSTANCE.useSaturationHSLMode ? "HSL" : "RGB"))).method_27692(class_124.field_1075));
        if (ModConfig.INSTANCE.useSaturationHSLMode) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Default: HSL Hue: " + String.format("%.2f", Float.valueOf(ModConfig.INSTANCE.saturationOverlayHue)) + ", Gamma: " + String.format("%.2f", Float.valueOf(ModConfig.INSTANCE.saturationOverlayGamma)))).method_27692(class_124.field_1054));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Default: RGB R: " + ModConfig.INSTANCE.saturationOverlayRed + ", G: " + ModConfig.INSTANCE.saturationOverlayGreen + ", B: " + ModConfig.INSTANCE.saturationOverlayBlue)).method_27692(class_124.field_1054));
        }
        boolean anySet = false;
        if (ModConfig.INSTANCE.drumstickColors != null && ModConfig.INSTANCE.drumstickColors.length == 30) {
            for (i = 0; i < 10; ++i) {
                r = ModConfig.INSTANCE.drumstickColors[i * 3];
                g = ModConfig.INSTANCE.drumstickColors[i * 3 + 1];
                b = ModConfig.INSTANCE.drumstickColors[i * 3 + 2];
                if (r < 0 || g < 0 || b < 0) continue;
                anySet = true;
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Drumstick %d: R=%d G=%d B=%d", i + 1, r, g, b)).method_27692(class_124.field_1080));
            }
        }
        if (!anySet) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"All drumsticks use default color.").method_27692(class_124.field_1063));
        } else {
            for (i = 0; i < 10; ++i) {
                r = ModConfig.INSTANCE.drumstickColors[i * 3];
                g = ModConfig.INSTANCE.drumstickColors[i * 3 + 1];
                b = ModConfig.INSTANCE.drumstickColors[i * 3 + 2];
                if (r >= 0 && g >= 0 && b >= 0) continue;
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Drumstick %d: default", i + 1)).method_27692(class_124.field_1063));
            }
        }
        return 1;
    }

    private static int setDrumstickColorRGB(CommandContext<FabricClientCommandSource> context) {
        int index = IntegerArgumentType.getInteger(context, (String)"index") - 1;
        int red = IntegerArgumentType.getInteger(context, (String)"red");
        int green = IntegerArgumentType.getInteger(context, (String)"green");
        int blue = IntegerArgumentType.getInteger(context, (String)"blue");
        if (ModConfig.INSTANCE.drumstickColors == null || ModConfig.INSTANCE.drumstickColors.length != 30) {
            ModConfig.INSTANCE.drumstickColors = new int[30];
            for (int i = 0; i < 10; ++i) {
                ModConfig.INSTANCE.drumstickColors[i * 3] = -1;
                ModConfig.INSTANCE.drumstickColors[i * 3 + 1] = -1;
                ModConfig.INSTANCE.drumstickColors[i * 3 + 2] = -1;
            }
        }
        ModConfig.INSTANCE.drumstickColors[index * 3] = red;
        ModConfig.INSTANCE.drumstickColors[index * 3 + 1] = green;
        ModConfig.INSTANCE.drumstickColors[index * 3 + 2] = blue;
        BannanaCommand.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Set drumstick " + (index + 1) + " color: R=" + red + " G=" + green + " B=" + blue)));
        return 1;
    }

    private static int setDrumstickColorHSL(CommandContext<FabricClientCommandSource> context) {
        float b;
        float g;
        float r;
        int index = IntegerArgumentType.getInteger(context, (String)"index") - 1;
        float hue = FloatArgumentType.getFloat(context, (String)"hue");
        float gamma = FloatArgumentType.getFloat(context, (String)"gamma");
        float saturation = 1.0f;
        float lightness = gamma * 0.5f;
        float c = (1.0f - Math.abs(2.0f * lightness - 1.0f)) * saturation;
        float x = c * (1.0f - Math.abs(hue * 6.0f % 2.0f - 1.0f));
        float m = lightness - c / 2.0f;
        if (hue < 0.16666667f) {
            r = c;
            g = x;
            b = 0.0f;
        } else if (hue < 0.33333334f) {
            r = x;
            g = c;
            b = 0.0f;
        } else if (hue < 0.5f) {
            r = 0.0f;
            g = c;
            b = x;
        } else if (hue < 0.6666667f) {
            r = 0.0f;
            g = x;
            b = c;
        } else if (hue < 0.8333333f) {
            r = x;
            g = 0.0f;
            b = c;
        } else {
            r = c;
            g = 0.0f;
            b = x;
        }
        int red = (int)((r + m) * 255.0f);
        int green = (int)((g + m) * 255.0f);
        int blue = (int)((b + m) * 255.0f);
        if (ModConfig.INSTANCE.drumstickColors == null || ModConfig.INSTANCE.drumstickColors.length != 30) {
            ModConfig.INSTANCE.drumstickColors = new int[30];
            for (int i = 0; i < 10; ++i) {
                ModConfig.INSTANCE.drumstickColors[i * 3] = -1;
                ModConfig.INSTANCE.drumstickColors[i * 3 + 1] = -1;
                ModConfig.INSTANCE.drumstickColors[i * 3 + 2] = -1;
            }
        }
        ModConfig.INSTANCE.drumstickColors[index * 3] = red;
        ModConfig.INSTANCE.drumstickColors[index * 3 + 1] = green;
        ModConfig.INSTANCE.drumstickColors[index * 3 + 2] = blue;
        BannanaCommand.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Set drumstick " + (index + 1) + " color: HSL->RGB R=" + red + " G=" + green + " B=" + blue)));
        return 1;
    }

    private static void saveConfig() {
        AutoConfig.getConfigHolder(ModConfig.class).save();
        ModConfig.INSTANCE = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
    }

    private static int savePreset(String name, CommandContext<FabricClientCommandSource> context) {
        if (presets.containsKey(name)) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"You already have a preset with this name!").method_27692(class_124.field_1061));
            return 0;
        }
        BannanaCommand.pushUndo();
        presets.put(name, new Preset(ModConfig.INSTANCE));
        BannanaCommand.savePresetsToFile();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Saved preset: " + name)).method_27692(class_124.field_1060));
        return 1;
    }

    private static int loadPreset(String name, CommandContext<FabricClientCommandSource> context) {
        Preset preset = presets.get(name);
        if (preset == null) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Preset not found: " + name)).method_27692(class_124.field_1061));
            return 0;
        }
        preset.apply(ModConfig.INSTANCE);
        BannanaCommand.saveConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Loaded preset: " + name)).method_27692(class_124.field_1060));
        return 1;
    }

    private static int deletePreset(String name, CommandContext<FabricClientCommandSource> context) {
        if (presets.remove(name) != null) {
            BannanaCommand.savePresetsToFile();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Deleted preset: " + name)).method_27692(class_124.field_1060));
            return 1;
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Preset not found: " + name)).method_27692(class_124.field_1061));
        return 0;
    }

    private static int listPresets(CommandContext<FabricClientCommandSource> context) {
        if (presets.isEmpty()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"No presets saved.").method_27692(class_124.field_1061));
            return 1;
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"=== Preset List ===").method_27692(class_124.field_1065));
        for (String name : presets.keySet()) {
            class_5250 clickable = class_2561.method_43470((String)name).method_27694(style -> style.method_10977(class_124.field_1075).method_10958(new class_2558(class_2558.class_2559.field_11750, "/banana preset_info " + name)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Show info for '" + name + "'")))));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)clickable);
        }
        return 1;
    }

    public static int showPresetInfo(CommandContext<FabricClientCommandSource> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        Preset preset = presets.get(name);
        if (preset == null) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Preset not found: " + name)).method_27692(class_124.field_1061));
            return 0;
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("=== Preset: " + name + " ===")).method_27692(class_124.field_1065));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("Mode: " + (preset.hslMode ? "HSL" : "RGB"))).method_27692(class_124.field_1075));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("RGB: R=%d G=%d B=%d", preset.red, preset.green, preset.blue)).method_27692(class_124.field_1054));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("HSL: Hue=%.2f Gamma=%.2f", Float.valueOf(preset.hue), Float.valueOf(preset.gamma))).method_27692(class_124.field_1076));
        if (preset.drumstickColors != null) {
            for (int i = 0; i < 10; ++i) {
                int r = preset.drumstickColors[i * 3];
                int g = preset.drumstickColors[i * 3 + 1];
                int b = preset.drumstickColors[i * 3 + 2];
                if (r < 0 || g < 0 || b < 0) continue;
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)String.format("Drumstick %d: R=%d G=%d B=%d", i + 1, r, g, b)).method_27692(class_124.field_1080));
            }
        }
        return 1;
    }

    static {
        BannanaCommand.loadPresetsFromFile();
        shiftScheduler = Executors.newSingleThreadScheduledExecutor();
        shiftTask = null;
        shiftDirection = null;
        undoStack = new Stack();
        redoStack = new Stack();
        shiftPaused = false;
    }

    private static class Preset {
        public int red;
        public int green;
        public int blue;
        public float hue;
        public float gamma;
        public boolean hslMode;
        public int[] drumstickColors;

        Preset() {
        }

        Preset(ModConfig config) {
            this.red = config.saturationOverlayRed;
            this.green = config.saturationOverlayGreen;
            this.blue = config.saturationOverlayBlue;
            this.hue = config.saturationOverlayHue;
            this.gamma = config.saturationOverlayGamma;
            this.hslMode = config.useSaturationHSLMode;
            this.drumstickColors = config.drumstickColors != null ? (int[])config.drumstickColors.clone() : null;
        }

        void apply(ModConfig config) {
            config.saturationOverlayRed = this.red;
            config.saturationOverlayGreen = this.green;
            config.saturationOverlayBlue = this.blue;
            config.saturationOverlayHue = this.hue;
            config.saturationOverlayGamma = this.gamma;
            config.useSaturationHSLMode = this.hslMode;
            config.drumstickColors = this.drumstickColors != null ? (int[])this.drumstickColors.clone() : null;
        }
    }
}

