/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.blocks;

import com.shim.celestialexploration.blocks.BaseMagRailBlock;
import com.shim.celestialexploration.blocks.MagRailState;
import com.shim.celestialexploration.entity.vehicle.AbstractMagCart;
import com.shim.celestialexploration.entity.vehicle.MagCartCommandBlock;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;

public class DetectorMagRailBlock
extends BaseMagRailBlock {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.f_61404_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final int PRESSED_CHECK_PERIOD = 20;

    public DetectorMagRailBlock(BlockBehaviour.Properties p_52431_) {
        super(true, p_52431_);
        this.registerDefaultState();
    }

    protected void registerDefaultState() {
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public boolean m_7899_(BlockState p_52489_) {
        return true;
    }

    public void m_7892_(BlockState p_52458_, Level p_52459_, BlockPos p_52460_, Entity p_52461_) {
        if (!p_52459_.f_46443_ && !((Boolean)p_52458_.m_61143_((Property)POWERED)).booleanValue()) {
            this.checkPressed(p_52459_, p_52460_, p_52458_);
        }
    }

    public void m_7458_(BlockState p_52444_, ServerLevel p_52445_, BlockPos p_52446_, Random p_52447_) {
        if (((Boolean)p_52444_.m_61143_((Property)POWERED)).booleanValue()) {
            this.checkPressed((Level)p_52445_, p_52446_, p_52444_);
        }
    }

    public int m_6378_(BlockState p_52449_, BlockGetter p_52450_, BlockPos p_52451_, Direction p_52452_) {
        return (Boolean)p_52449_.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState p_52478_, BlockGetter p_52479_, BlockPos p_52480_, Direction p_52481_) {
        if (!((Boolean)p_52478_.m_61143_((Property)POWERED)).booleanValue()) {
            return 0;
        }
        return p_52481_ == Direction.UP ? 15 : 0;
    }

    private void checkPressed(Level p_52433_, BlockPos p_52434_, BlockState p_52435_) {
        if (this.m_7898_(p_52435_, (LevelReader)p_52433_, p_52434_)) {
            boolean flag = (Boolean)p_52435_.m_61143_((Property)POWERED);
            boolean flag1 = false;
            List<AbstractMagCart> list = this.getInteractingMagCartOfType(p_52433_, p_52434_, AbstractMagCart.class, p_153125_ -> true);
            if (!list.isEmpty()) {
                flag1 = true;
            }
            if (flag1 && !flag) {
                BlockState blockstate = (BlockState)p_52435_.m_61124_((Property)POWERED, (Comparable)Boolean.TRUE);
                p_52433_.m_7731_(p_52434_, blockstate, 3);
                this.updatePowerToConnected(p_52433_, p_52434_, blockstate, true);
                p_52433_.m_46672_(p_52434_, (Block)this);
                p_52433_.m_46672_(p_52434_.m_7495_(), (Block)this);
                p_52433_.m_6550_(p_52434_, p_52435_, blockstate);
            }
            if (!flag1 && flag) {
                BlockState blockstate1 = (BlockState)p_52435_.m_61124_((Property)POWERED, (Comparable)Boolean.FALSE);
                p_52433_.m_7731_(p_52434_, blockstate1, 3);
                this.updatePowerToConnected(p_52433_, p_52434_, blockstate1, false);
                p_52433_.m_46672_(p_52434_, (Block)this);
                p_52433_.m_46672_(p_52434_.m_7495_(), (Block)this);
                p_52433_.m_6550_(p_52434_, p_52435_, blockstate1);
            }
            if (flag1) {
                p_52433_.m_186460_(p_52434_, (Block)this, 20);
            }
            p_52433_.m_46717_(p_52434_, (Block)this);
        }
    }

    protected void updatePowerToConnected(Level p_52473_, BlockPos p_52474_, BlockState p_52475_, boolean p_52476_) {
        MagRailState railstate = new MagRailState(p_52473_, p_52474_, p_52475_);
        for (BlockPos blockpos : railstate.getConnections()) {
            BlockState blockstate = p_52473_.m_8055_(blockpos);
            blockstate.m_60690_(p_52473_, blockpos, blockstate.m_60734_(), p_52474_, false);
        }
    }

    @Override
    public void m_6807_(BlockState p_52483_, Level p_52484_, BlockPos p_52485_, BlockState p_52486_, boolean p_52487_) {
        if (!p_52486_.m_60713_(p_52483_.m_60734_())) {
            BlockState blockstate = this.updateState(p_52483_, p_52484_, p_52485_, p_52487_);
            this.checkPressed(p_52484_, p_52485_, blockstate);
        }
    }

    @Override
    public Property<RailShape> getShapeProperty() {
        return SHAPE;
    }

    public boolean m_7278_(BlockState p_52442_) {
        return true;
    }

    public int m_6782_(BlockState p_52454_, Level p_52455_, BlockPos p_52456_) {
        if (((Boolean)p_52454_.m_61143_((Property)POWERED)).booleanValue()) {
            List<MagCartCommandBlock> list = this.getInteractingMagCartOfType(p_52455_, p_52456_, MagCartCommandBlock.class, p_153123_ -> true);
            if (!list.isEmpty()) {
                return list.get(0).getCommandBlock().m_45436_();
            }
            List<AbstractMagCart> carts = this.getInteractingMagCartOfType(p_52455_, p_52456_, AbstractMagCart.class, e -> e.m_6084_());
            if (!carts.isEmpty() && carts.get(0).getComparatorLevel() > -1) {
                return carts.get(0).getComparatorLevel();
            }
            List list1 = carts.stream().filter(EntitySelector.f_20405_).collect(Collectors.toList());
            if (!list1.isEmpty()) {
                return AbstractContainerMenu.m_38938_((Container)((Container)list1.get(0)));
            }
        }
        return 0;
    }

    private <T extends AbstractMagCart> List<T> getInteractingMagCartOfType(Level p_52437_, BlockPos p_52438_, Class<T> p_52439_, Predicate<Entity> p_52440_) {
        return p_52437_.m_6443_(p_52439_, this.getSearchBB(p_52438_), p_52440_);
    }

    private AABB getSearchBB(BlockPos p_52471_) {
        double d0 = 0.2;
        return new AABB((double)p_52471_.m_123341_() + 0.2, (double)p_52471_.m_123342_(), (double)p_52471_.m_123343_() + 0.2, (double)(p_52471_.m_123341_() + 1) - 0.2, (double)(p_52471_.m_123342_() + 1) - 0.2, (double)(p_52471_.m_123343_() + 1) - 0.2);
    }

    public BlockState m_6843_(BlockState p_52466_, Rotation p_52467_) {
        switch (p_52467_) {
            case CLOCKWISE_180: {
                switch ((RailShape)p_52466_.m_61143_(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch ((RailShape)p_52466_.m_61143_(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch ((RailShape)p_52466_.m_61143_(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)p_52466_.m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
        }
        return p_52466_;
    }

    public BlockState m_6943_(BlockState p_52463_, Mirror p_52464_) {
        RailShape railshape = (RailShape)p_52463_.m_61143_(SHAPE);
        block0 : switch (p_52464_) {
            case LEFT_RIGHT: {
                switch (railshape) {
                    case ASCENDING_NORTH: {
                        return (BlockState)p_52463_.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)p_52463_.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_52463_.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_52463_.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_52463_.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)p_52463_.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                }
                return super.m_6943_(p_52463_, p_52464_);
            }
            case FRONT_BACK: {
                switch (railshape) {
                    case ASCENDING_EAST: {
                        return (BlockState)p_52463_.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)p_52463_.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return (BlockState)p_52463_.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)p_52463_.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)p_52463_.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return (BlockState)p_52463_.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
            }
        }
        return super.m_6943_(p_52463_, p_52464_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_52469_) {
        p_52469_.m_61104_(new Property[]{this.getShapeProperty(), POWERED, WATERLOGGED});
    }
}

