/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.blocks.blockentities;

import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.blocks.OxygenCompressorBlock;
import com.shim.celestialexploration.capabilities.LoxTankCapability;
import com.shim.celestialexploration.inventory.menus.OxygenCompressorMenu;
import com.shim.celestialexploration.registry.CelestialBlockEntities;
import com.shim.celestialexploration.registry.CelestialCapabilities;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OxygenCompressorBlockEntity
extends BlockEntity
implements MenuProvider {
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 150;
    private int fuelBurnTime = 0;
    private int maxFuelBurnTime;
    private final ItemStackHandler itemHandler = new ItemStackHandler(7){

        protected void onContentsChanged(int slot) {
            OxygenCompressorBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();

    public OxygenCompressorBlockEntity(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)CelestialBlockEntities.OXYGEN_COMPRESSOR_BLOCK_ENTITY.get(), worldPosition, blockState);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> OxygenCompressorBlockEntity.this.progress;
                    case 1 -> OxygenCompressorBlockEntity.this.maxProgress;
                    case 2 -> OxygenCompressorBlockEntity.this.fuelBurnTime;
                    case 3 -> OxygenCompressorBlockEntity.this.maxFuelBurnTime;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        OxygenCompressorBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        OxygenCompressorBlockEntity.this.maxProgress = value;
                        break;
                    }
                    case 2: {
                        OxygenCompressorBlockEntity.this.fuelBurnTime = value;
                        break;
                    }
                    case 3: {
                        OxygenCompressorBlockEntity.this.maxFuelBurnTime = value;
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        };
    }

    public Component m_5446_() {
        return new TranslatableComponent("container.celestialexploration.oxygen_compressor");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new OxygenCompressorMenu(containerId, inventory, this, this.data);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("oxygen_compressor.progress", this.progress);
        tag.m_128405_("oxygen_compressor.maxProgress", this.maxProgress);
        tag.m_128405_("oxygen_compressor.fuelBurnTime", this.fuelBurnTime);
        tag.m_128405_("oxygen_compressor.maxFuelBurnTime", this.maxFuelBurnTime);
        super.m_183515_(tag);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("oxygen_compressor.progress");
        this.maxProgress = nbt.m_128451_("oxygen_compressor.maxProgress");
        this.fuelBurnTime = nbt.m_128451_("oxygen_compressor.fuelBurnTime");
        this.maxFuelBurnTime = nbt.m_128451_("oxygen_compressor.maxFuelBurnTime");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public boolean isLit() {
        return this.fuelBurnTime > 0;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, OxygenCompressorBlockEntity blockEntity) {
        boolean lit = blockEntity.isLit();
        boolean changed = false;
        SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        if (lit) {
            --blockEntity.fuelBurnTime;
        }
        ItemStack fuelItem = blockEntity.itemHandler.getStackInSlot(0);
        ItemStack tankItemOne = blockEntity.itemHandler.getStackInSlot(1);
        ItemStack tankItemTwo = blockEntity.itemHandler.getStackInSlot(2);
        ItemStack tankItemThree = blockEntity.itemHandler.getStackInSlot(3);
        ItemStack tankItemFour = blockEntity.itemHandler.getStackInSlot(4);
        if (!(!lit && (fuelItem.m_41619_() || tankItemOne.m_41619_() && tankItemTwo.m_41619_() && tankItemThree.m_41619_() && tankItemFour.m_41619_()))) {
            if (!blockEntity.isLit() && OxygenCompressorBlockEntity.hasRoomInTank(blockEntity)) {
                blockEntity.maxFuelBurnTime = blockEntity.fuelBurnTime = ForgeHooks.getBurnTime((ItemStack)fuelItem, (RecipeType)RecipeType.f_44108_);
                if (blockEntity.isLit()) {
                    changed = true;
                    if (fuelItem.hasContainerItem()) {
                        blockEntity.itemHandler.setStackInSlot(0, fuelItem.getContainerItem());
                    } else if (!fuelItem.m_41619_()) {
                        fuelItem.m_41774_(1);
                        if (fuelItem.m_41619_()) {
                            blockEntity.itemHandler.setStackInSlot(0, fuelItem.getContainerItem());
                        }
                    }
                }
            }
            if (blockEntity.isLit() && OxygenCompressorBlockEntity.hasRoomInTank(blockEntity)) {
                ++blockEntity.progress;
                if (blockEntity.progress == blockEntity.maxProgress) {
                    blockEntity.progress = 0;
                    blockEntity.maxProgress = 150;
                    ItemStack firstSlot = blockEntity.itemHandler.getStackInSlot(1);
                    ItemStack secondSlot = blockEntity.itemHandler.getStackInSlot(2);
                    ItemStack thirdSlot = blockEntity.itemHandler.getStackInSlot(3);
                    ItemStack fourthSlot = blockEntity.itemHandler.getStackInSlot(4);
                    LoxTankCapability.ILoxTank loxTank = CelestialExploration.getCapability(firstSlot, CelestialCapabilities.LOX_TANK_CAPABILITY);
                    LoxTankCapability.ILoxTank secondloxTank = CelestialExploration.getCapability(secondSlot, CelestialCapabilities.LOX_TANK_CAPABILITY);
                    LoxTankCapability.ILoxTank thirdloxTank = CelestialExploration.getCapability(thirdSlot, CelestialCapabilities.LOX_TANK_CAPABILITY);
                    LoxTankCapability.ILoxTank fourthloxTank = CelestialExploration.getCapability(fourthSlot, CelestialCapabilities.LOX_TANK_CAPABILITY);
                    if (loxTank != null && !loxTank.isFull()) {
                        loxTank.incrementAmount();
                    } else if (secondloxTank != null && !secondloxTank.isFull()) {
                        secondloxTank.incrementAmount();
                    } else if (thirdloxTank != null && !thirdloxTank.isFull()) {
                        thirdloxTank.incrementAmount();
                    } else if (fourthloxTank != null && !fourthloxTank.isFull()) {
                        fourthloxTank.incrementAmount();
                    }
                    changed = true;
                }
            } else {
                blockEntity.progress = 0;
            }
        } else if (!blockEntity.isLit() && blockEntity.progress > 0) {
            blockEntity.progress = Mth.m_14045_((int)(blockEntity.progress - 2), (int)0, (int)blockEntity.maxProgress);
        }
        if (lit != blockEntity.isLit()) {
            changed = true;
            state = (BlockState)state.m_61124_((Property)OxygenCompressorBlock.LIT, (Comparable)Boolean.valueOf(blockEntity.isLit()));
            level.m_7731_(pos, state, 3);
        }
        if (changed) {
            OxygenCompressorBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static boolean hasRoomInTank(OxygenCompressorBlockEntity blockEntity) {
        ItemStack firstSlot = blockEntity.itemHandler.getStackInSlot(1);
        ItemStack secondSlot = blockEntity.itemHandler.getStackInSlot(2);
        ItemStack thirdSlot = blockEntity.itemHandler.getStackInSlot(3);
        ItemStack fourthSlot = blockEntity.itemHandler.getStackInSlot(4);
        LoxTankCapability.ILoxTank loxTank = CelestialExploration.getCapability(firstSlot, CelestialCapabilities.LOX_TANK_CAPABILITY);
        LoxTankCapability.ILoxTank secondLoxTank = CelestialExploration.getCapability(secondSlot, CelestialCapabilities.LOX_TANK_CAPABILITY);
        LoxTankCapability.ILoxTank thirdLoxTank = CelestialExploration.getCapability(thirdSlot, CelestialCapabilities.LOX_TANK_CAPABILITY);
        LoxTankCapability.ILoxTank fourthLoxTank = CelestialExploration.getCapability(fourthSlot, CelestialCapabilities.LOX_TANK_CAPABILITY);
        if (loxTank != null && !loxTank.isFull()) {
            return true;
        }
        if (secondLoxTank != null && !secondLoxTank.isFull()) {
            return true;
        }
        if (thirdLoxTank != null && !thirdLoxTank.isFull()) {
            return true;
        }
        return fourthLoxTank != null && !fourthLoxTank.isFull();
    }
}

