/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.blocks.blockentities;

import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.entity.vehicle.SpaceTaxi;
import com.shim.celestialexploration.inventory.menus.TaxiStationMenu;
import com.shim.celestialexploration.registry.CelestialBlockEntities;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaxiStationBlockEntity
extends BlockEntity
implements MenuProvider {
    protected final ContainerData data;
    List<TaxiAndPassengers> incomingTaxis;
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TaxiStationBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();

    public TaxiStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CelestialBlockEntities.TAXI_STATION_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> 4;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
            }

            public int m_6499_() {
                return 4;
            }
        };
        this.incomingTaxis = new ArrayList<TaxiAndPassengers>();
    }

    public Component m_5446_() {
        return new TranslatableComponent("container.celestialexploration.taxi_station");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new TaxiStationMenu(containerId, inventory, this, this.data);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(tag);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TaxiStationBlockEntity blockEntity) {
        if (level.m_46468_() == 7000L) {
            CelestialExploration.LOGGER.debug("incomingTaxis: " + blockEntity.incomingTaxis);
            for (TaxiAndPassengers taxi : blockEntity.incomingTaxis) {
                blockEntity.incomingTaxis.remove(taxi);
                taxi.taxi().m_6027_(pos.m_123341_(), pos.m_6630_(50).m_123342_(), pos.m_123343_());
                level.m_7967_((Entity)taxi.taxi());
                for (Entity passenger : taxi.passengers()) {
                    passenger.m_6027_((double)pos.m_123341_(), (double)pos.m_6630_(50).m_123342_(), (double)pos.m_123343_());
                    level.m_7967_(passenger);
                    passenger.m_20329_((Entity)taxi.taxi());
                }
                taxi.taxi().setDescent();
            }
        }
    }

    public void setIncomingTaxi(SpaceTaxi taxi, List<Entity> passengers) {
        this.incomingTaxis.add(new TaxiAndPassengers(taxi, passengers));
        this.saveTaxiPassengers();
        CelestialExploration.LOGGER.debug("incomingTaxis: " + this.incomingTaxis);
    }

    private void saveTaxiPassengers() {
        CompoundTag nbt = new CompoundTag();
        for (TaxiAndPassengers taxi : this.incomingTaxis) {
            nbt = taxi.taxi().m_20240_(nbt);
            SpaceTaxi newTaxi = (SpaceTaxi)EntityType.m_20642_((CompoundTag)nbt, (Level)taxi.taxi().f_19853_).get();
            ArrayList<Entity> passengers = new ArrayList<Entity>();
            for (Entity entity : taxi.passengers()) {
                nbt = new CompoundTag();
                nbt = entity.m_20240_(nbt);
                Entity newEntity = (Entity)EntityType.m_20642_((CompoundTag)nbt, (Level)entity.f_19853_).get();
                passengers.add(newEntity);
            }
            this.incomingTaxis.remove(taxi);
            this.incomingTaxis.add(new TaxiAndPassengers(newTaxi, passengers));
        }
    }

    public record TaxiAndPassengers(SpaceTaxi taxi, List<Entity> passengers) {
    }
}

