/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.capabilities;

import com.shim.celestialexploration.registry.CelestialCapabilities;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoxTankCapability {

    public static class LoxTankCapabilityProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        public static Capability<LoxTankHandler> LOX_TANK = CapabilityManager.get((CapabilityToken)new CapabilityToken<LoxTankHandler>(){});
        private LoxTankHandler loxTankHandler = null;
        private final LazyOptional<LoxTankHandler> lazyLoxTank = LazyOptional.of(this::createLoxHandler);

        @Nonnull
        private LoxTankHandler createLoxHandler() {
            if (this.loxTankHandler == null) {
                this.loxTankHandler = new LoxTankHandler();
            }
            return this.loxTankHandler;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return CelestialCapabilities.LOX_TANK_CAPABILITY.orEmpty(cap, this.lazyLoxTank.cast());
        }

        public CompoundTag serializeNBT() {
            return ((LoxTankHandler)this.lazyLoxTank.orElseThrow(NullPointerException::new)).getLoxData();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((LoxTankHandler)this.lazyLoxTank.orElseThrow(NullPointerException::new)).setLoxData(nbt);
        }
    }

    public static class LoxTankHandler
    implements ILoxTank {
        private int loxAmount;
        private int fullness;
        private static final int DEFAULT_CAPACITY = 8000;

        @Override
        public int getAmount() {
            return this.loxAmount;
        }

        @Override
        public void setAmount(int amount) {
            this.loxAmount = amount;
            this.fullness = (int)((double)this.loxAmount / 8000.0 * 8.0);
        }

        @Override
        public void incrementAmount() {
            if (this.loxAmount < 8000) {
                if (this.loxAmount <= 7000) {
                    this.loxAmount += 1000;
                    this.fullness = (int)((double)this.loxAmount / 8000.0 * 8.0);
                } else {
                    this.loxAmount += 8000 - this.loxAmount;
                }
            }
        }

        @Override
        public void decrementAmount() {
            if (this.loxAmount > 0) {
                this.loxAmount -= 100;
                this.fullness = (int)((double)this.loxAmount / 8000.0 * 8.0);
            }
        }

        @Override
        public void decrementAmountByFifty() {
            if (this.loxAmount > 0) {
                this.loxAmount -= 50;
                this.fullness = (int)((double)this.loxAmount / 8000.0 * 8.0);
            }
        }

        @Override
        public CompoundTag getLoxData() {
            CompoundTag loxData = new CompoundTag();
            loxData.m_128405_("amount", this.loxAmount);
            loxData.m_128405_("fullness", this.fullness);
            return loxData;
        }

        @Override
        public void setFullness() {
            this.fullness = (int)((double)this.loxAmount / 8000.0 * 8.0);
        }

        @Override
        public int getFullness() {
            this.fullness = (int)((double)this.loxAmount / 8000.0 * 8.0);
            return this.fullness;
        }

        @Override
        public boolean isFull() {
            return this.loxAmount >= 8000;
        }

        @Override
        public boolean isEmpty() {
            return this.loxAmount <= 0;
        }

        @Override
        public void setLoxData(CompoundTag nbt) {
            if (nbt.m_128441_("amount")) {
                this.loxAmount = nbt.m_128451_("amount");
            }
            if (nbt.m_128441_("fullness")) {
                this.fullness = nbt.m_128451_("fullness");
            }
        }
    }

    public static interface ILoxTank {
        public int getAmount();

        public void setAmount(int var1);

        public void incrementAmount();

        public void decrementAmount();

        public void decrementAmountByFifty();

        public CompoundTag getLoxData();

        public void setFullness();

        public int getFullness();

        public boolean isFull();

        public boolean isEmpty();

        public void setLoxData(CompoundTag var1);
    }
}

