/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.capabilities;

import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.registry.CelestialCapabilities;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaxiCapability {

    public static class TaxiProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        public static Capability<TaxiHandler> TAXI = CapabilityManager.get((CapabilityToken)new CapabilityToken<TaxiHandler>(){});
        private TaxiHandler taxiHandler = null;
        private final LazyOptional<TaxiHandler> lazyTaxi = LazyOptional.of(this::createHandler);

        @Nonnull
        private TaxiHandler createHandler() {
            if (this.taxiHandler == null) {
                this.taxiHandler = new TaxiHandler();
            }
            return this.taxiHandler;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return CelestialCapabilities.TAXI_CAPABILITY.orEmpty(cap, this.lazyTaxi.cast());
        }

        public CompoundTag serializeNBT() {
            return ((TaxiHandler)this.lazyTaxi.orElseThrow(NullPointerException::new)).getData();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((TaxiHandler)this.lazyTaxi.orElseThrow(NullPointerException::new)).setData(nbt);
        }
    }

    public static class TaxiHandler
    implements ITaxi {
        private final List<TaxiStationData> taxiStationData = new ArrayList<TaxiStationData>();

        @Override
        public List<TaxiStationData> getTaxiStations() {
            return this.taxiStationData;
        }

        @Override
        public void addTaxiStations(TaxiStationData data) {
            this.taxiStationData.add(data);
            for (TaxiStationData taxiStationDatum : this.taxiStationData) {
                CelestialExploration.LOGGER.debug(taxiStationDatum.toString());
            }
        }

        @Override
        public void removeTaxiStations(TaxiStationData data) {
            this.taxiStationData.remove(data);
        }

        @Override
        public void removeTaxiStations(BlockPos pos) {
            ChunkPos chunkPos = new ChunkPos(pos);
            for (TaxiStationData taxiStationDatum : this.taxiStationData) {
                ChunkPos chunkToCheck = new ChunkPos(taxiStationDatum.pos());
                if (!chunkToCheck.equals((Object)chunkPos)) continue;
                this.taxiStationData.remove(taxiStationDatum);
            }
        }

        @Override
        public boolean existsAtThisPos(BlockPos pos) {
            ChunkPos chunkPos = new ChunkPos(pos);
            for (TaxiStationData taxiStationDatum : this.taxiStationData) {
                ChunkPos chunkToCheck = new ChunkPos(taxiStationDatum.pos());
                if (!chunkToCheck.equals((Object)chunkPos)) continue;
                return true;
            }
            return false;
        }

        @Override
        public CompoundTag getData() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("size", this.taxiStationData.size());
            for (int i = 0; i < this.taxiStationData.size(); ++i) {
                nbt.m_128405_("x_" + i, this.taxiStationData.get(i).pos().m_123341_());
                nbt.m_128405_("y_" + i, this.taxiStationData.get(i).pos().m_123342_());
                nbt.m_128405_("z_" + i, this.taxiStationData.get(i).pos().m_123343_());
                nbt.m_128359_("dimension_" + i, this.taxiStationData.get(i).dimension().m_135782_().m_135815_());
                nbt.m_128359_("name_" + i, this.taxiStationData.get(i).name().getString());
                CelestialExploration.LOGGER.debug("saving! i:" + i + ", xyz: " + nbt.m_128451_("x_" + i) + "/" + nbt.m_128451_("y_" + i) + "/" + nbt.m_128451_("z_" + i) + ", dimension: " + nbt.m_128461_("dimension_" + i) + ", name: " + nbt.m_128461_("name_" + i));
            }
            return nbt;
        }

        @Override
        public void setData(CompoundTag nbt) {
            if (nbt.m_128441_("size")) {
                int size = nbt.m_128451_("size");
                CelestialExploration.LOGGER.debug("loading! size: " + size);
                for (int i = 0; i < size; ++i) {
                    int x = 0;
                    int y = 0;
                    int z = 0;
                    if (nbt.m_128441_("x_" + i)) {
                        x = nbt.m_128451_("x_" + i);
                    }
                    if (nbt.m_128441_("y_" + i)) {
                        y = nbt.m_128451_("y_" + i);
                    }
                    if (nbt.m_128441_("z_" + i)) {
                        z = nbt.m_128451_("z_" + i);
                    }
                    BlockPos pos = new BlockPos(x, y, z);
                    String dimensionString = null;
                    if (nbt.m_128441_("dimension_" + i)) {
                        dimensionString = nbt.m_128461_("dimension_" + i);
                    }
                    if (dimensionString == null) continue;
                    ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(dimensionString));
                    TextComponent name = null;
                    if (nbt.m_128441_("name_" + i)) {
                        name = new TextComponent(nbt.m_128461_("name_" + i));
                    }
                    if (name == null) continue;
                    this.taxiStationData.add(new TaxiStationData(pos, (ResourceKey<Level>)dimension, (Component)name));
                    CelestialExploration.LOGGER.debug("loading! i:" + i + ", xyz: " + nbt.m_128451_("x_" + i) + "/" + nbt.m_128451_("y_" + i) + "/" + nbt.m_128451_("z_" + i) + ", dimension: " + nbt.m_128461_("dimension_" + i) + ", name: " + nbt.m_128461_("name_" + i));
                }
            }
        }
    }

    public record TaxiStationData(BlockPos pos, ResourceKey<Level> dimension, Component name) {
        @Override
        public String toString() {
            return this.name.getString() + ", at " + this.pos + " in " + this.dimension;
        }
    }

    public static interface ITaxi {
        public List<TaxiStationData> getTaxiStations();

        public void addTaxiStations(TaxiStationData var1);

        public void removeTaxiStations(TaxiStationData var1);

        public void removeTaxiStations(BlockPos var1);

        public boolean existsAtThisPos(BlockPos var1);

        public CompoundTag getData();

        public void setData(CompoundTag var1);
    }
}

