/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.capabilities;

import com.shim.celestialexploration.registry.CelestialCapabilities;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerTravelCapability {

    public static class VillagerTravelCapabilityProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        public static Capability<TravelHandler> TRAVEL_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<TravelHandler>(){});
        private TravelHandler travelHandler = null;
        private final LazyOptional<TravelHandler> lazyTravelHandler = LazyOptional.of(this::createHandler);

        @Nonnull
        private TravelHandler createHandler() {
            if (this.travelHandler == null) {
                this.travelHandler = new TravelHandler();
            }
            return this.travelHandler;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return CelestialCapabilities.LOX_TANK_CAPABILITY.orEmpty(cap, this.lazyTravelHandler.cast());
        }

        public CompoundTag serializeNBT() {
            return ((TravelHandler)this.lazyTravelHandler.orElseThrow(NullPointerException::new)).getData();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((TravelHandler)this.lazyTravelHandler.orElseThrow(NullPointerException::new)).setData(nbt);
        }
    }

    public static class TravelHandler
    implements ITravel {
        Player player = null;
        boolean willingness = true;

        @Override
        public boolean isWillingToTravel() {
            return this.willingness;
        }

        @Override
        public void toggleTravelWillingness(Player player) {
            if (!this.willingness) {
                if (this.player == player) {
                    this.willingness = !this.willingness;
                }
            } else {
                this.willingness = !this.willingness;
                this.player = player;
            }
        }

        @Override
        public Player getPlayerWhoSet() {
            return this.player;
        }

        @Override
        public CompoundTag getData() {
            return new CompoundTag();
        }

        @Override
        public void setData(CompoundTag nbt) {
        }
    }

    public static interface ITravel {
        public boolean isWillingToTravel();

        public void toggleTravelWillingness(Player var1);

        public Player getPlayerWhoSet();

        public CompoundTag getData();

        public void setData(CompoundTag var1);
    }
}

