/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.datagen.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shim.celestialexploration.registry.CelestialRecipes;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class WorkbenchCraftingRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final int count;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private final Fluid fluid;
    private final float buckets;
    private final float experience;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @javax.annotation.Nullable
    private String group;

    private WorkbenchCraftingRecipeBuilder(ItemLike item, int count, Fluid fluid, float buckets, float experience) {
        this.result = item.m_5456_();
        this.count = count;
        this.fluid = fluid;
        this.buckets = buckets;
        this.experience = experience;
    }

    public static WorkbenchCraftingRecipeBuilder shaped(ItemLike item, Fluid fluid, float experience) {
        return WorkbenchCraftingRecipeBuilder.shaped(item, 1, fluid, experience);
    }

    public static WorkbenchCraftingRecipeBuilder shaped(ItemLike item, int count, Fluid fluid, float experience) {
        return WorkbenchCraftingRecipeBuilder.shaped(item, count, fluid, 1.0f, experience);
    }

    public static WorkbenchCraftingRecipeBuilder shaped(ItemLike item, Fluid fluid, float buckets, float experience) {
        return WorkbenchCraftingRecipeBuilder.shaped(item, 1, fluid, buckets, experience);
    }

    public static WorkbenchCraftingRecipeBuilder shaped(ItemLike item, int count, Fluid fluid, float buckets, float experience) {
        return new WorkbenchCraftingRecipeBuilder(item, count, fluid, buckets, experience);
    }

    public RecipeBuilder m_142284_(String p_176496_, CriterionTriggerInstance p_176497_) {
        this.advancement.m_138386_(p_176496_, p_176497_);
        return this;
    }

    public RecipeBuilder m_142409_(@Nullable String group) {
        this.group = group;
        return this;
    }

    public Item m_142372_() {
        return ItemStack.f_41583_.m_41720_();
    }

    public float getBuckets() {
        return this.buckets;
    }

    public WorkbenchCraftingRecipeBuilder define(Character p_206417_, TagKey<Item> p_206418_) {
        return this.define(p_206417_, Ingredient.m_204132_(p_206418_));
    }

    public WorkbenchCraftingRecipeBuilder define(Character p_126128_, ItemLike p_126129_) {
        return this.define(p_126128_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_126129_}));
    }

    public WorkbenchCraftingRecipeBuilder define(Character p_126125_, Ingredient p_126126_) {
        if (this.key.containsKey(p_126125_)) {
            throw new IllegalArgumentException("Symbol '" + p_126125_ + "' is already defined!");
        }
        if (p_126125_.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(p_126125_, p_126126_);
        return this;
    }

    public WorkbenchCraftingRecipeBuilder pattern(String p_126131_) {
        if (!this.rows.isEmpty() && p_126131_.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(p_126131_);
        return this;
    }

    public void m_142700_(Consumer<FinishedRecipe> consumer, ResourceLocation loc) {
        this.ensureValid(loc);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)loc)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)loc)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(loc, this.group == null ? "" : this.group, this.result, this.count, this.rows, this.key, this.fluid, this.buckets, this.experience, this.advancement, new ResourceLocation("celestialexploration", "recipes/" + loc.m_135815_())));
    }

    private void ensureValid(ResourceLocation p_126266_) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126266_);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Item result;
        private final int count;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Fluid fluid;
        private final float buckets;
        private final float experience;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, String group, Item result, int count, List<String> pattern, Map<Character, Ingredient> key, Fluid fluid, float buckets, float experience, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.group = group;
            this.result = result;
            this.count = count;
            this.pattern = pattern;
            this.key = key;
            this.fluid = fluid;
            this.buckets = buckets;
            this.experience = experience;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            json.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            json.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", Registry.f_122827_.m_7981_((Object)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
            json.addProperty("fluid", Registry.f_122822_.m_7981_((Object)this.fluid).toString());
            json.addProperty("buckets", (Number)Float.valueOf(this.buckets));
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)CelestialRecipes.WORKBENCH_CRAFTING_SERIALIZER.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @javax.annotation.Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @javax.annotation.Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

