/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.client.layers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.layer.AzAutoGlowingLayer;
import net.minecraft.Util;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractGlowLayer<T extends Entity>
extends AzAutoGlowingLayer<T> {
    private static final RenderStateShard.ShaderStateShard SHADER_STATE = new RenderStateShard.ShaderStateShard(GameRenderer::m_172700_);
    private static final RenderStateShard.TransparencyStateShard TRANSPARENCY_STATE = new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
    });
    private static final RenderStateShard.WriteMaskStateShard WRITE_MASK = new RenderStateShard.WriteMaskStateShard(true, false);
    private static final Function<ResourceLocation, RenderType> SMART_GLOW = Util.m_143827_(texture -> {
        RenderStateShard.TextureStateShard textureState = new RenderStateShard.TextureStateShard(texture, false, false);
        return RenderType.m_173215_((String)"smart_glow", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(SHADER_STATE).m_173290_((RenderStateShard.EmptyTextureStateShard)textureState).m_110685_(TRANSPARENCY_STATE).m_110687_(WRITE_MASK).m_110691_(false));
    });

    public abstract ResourceLocation getGlowTexture(T var1);

    public RenderType getRenderType(T animatable) {
        return SMART_GLOW.apply(this.getGlowTexture(animatable));
    }

    public void render(AzRendererPipelineContext<T> context) {
        Entity animatable = (Entity)context.animatable();
        RenderType glowingType = this.getRenderType(animatable);
        int prevPackedLight = context.packedLight();
        AzRendererPipeline renderPipeline = context.rendererPipeline();
        VertexConsumer prevVertexConsumer = context.vertexConsumer();
        if (context.renderType() != null) {
            RenderType prevRenderType = context.renderType();
            context.setPackedLight(0xF00000);
            context.setRenderType(glowingType);
            context.setVertexConsumer(context.multiBufferSource().m_6299_(glowingType));
            renderPipeline.reRender(context);
            context.setRenderType(prevRenderType);
            context.setPackedLight(prevPackedLight);
            context.setVertexConsumer(prevVertexConsumer);
        }
    }
}

