/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.shim.celestialexploration.entity.client.animators.GustAnimator;
import com.shim.celestialexploration.entity.mob.Gust;
import com.shim.celestialexploration.util.CelestialUtil;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GustRenderer
extends AzEntityRenderer<Gust> {
    private static final ResourceLocation GEO = CelestialUtil.getModLoc("geo/gust.geo.json");
    private static final ResourceLocation TEX = CelestialUtil.getModLoc("textures/entity/gust.png");

    public GustRenderer(EntityRendererProvider.Context context) {
        super(AzEntityRendererConfig.builder((ResourceLocation)GEO, (ResourceLocation)TEX).setAnimatorProvider(GustAnimator::new).build(), context);
    }

    public void render(@NotNull Gust entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        this.scale(entity, poseStack, partialTick);
        poseStack.m_85837_(0.0, (double)0.3f, 0.0);
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    protected void scale(Gust p_114046_, PoseStack p_114047_, float p_114048_) {
        float f = p_114046_.getSwelling(p_114048_);
        float f1 = 1.0f + Mth.m_14031_((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        p_114047_.m_85841_(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(Gust p_114043_, float p_114044_) {
        float f = p_114043_.getSwelling(p_114044_);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.m_14036_((float)f, (float)0.5f, (float)1.0f);
    }
}

