/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.shim.celestialexploration.entity.client.animators.SpaceTaxiAnimator;
import com.shim.celestialexploration.entity.client.layers.DyedGlowLayer;
import com.shim.celestialexploration.entity.client.renderer.SpaceshipRenderer;
import com.shim.celestialexploration.entity.vehicle.SpaceTaxi;
import com.shim.celestialexploration.util.CelestialUtil;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SpaceTaxiRenderer
extends AzEntityRenderer<SpaceTaxi> {
    public SpaceTaxiRenderer(EntityRendererProvider.Context context) {
        super(AzEntityRendererConfig.builder(SpaceshipRenderer::getModel, SpaceTaxiRenderer::getTexture).setAnimatorProvider(SpaceTaxiAnimator::new).setScale(1.7f).addRenderLayer(new DyedGlowLayer()).build(), context);
    }

    public static ResourceLocation getTexture(SpaceTaxi spaceship) {
        return CelestialUtil.getModLoc("textures/entity/spaceship/taxi.png");
    }

    public void render(@NotNull SpaceTaxi entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        float lerpBodyRot = Mth.m_14189_((float)partialTick, (float)entity.f_19859_, (float)entity.m_146908_());
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - lerpBodyRot));
        if (entity.m_20184_().f_82480_ > 0.0) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(5.0f));
        }
        if (entity.m_20184_().f_82480_ < 0.0) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-5.0f));
        }
        if (entity.deltaRotation < 0.0f) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(5.0f));
        }
        if (entity.deltaRotation > 0.0f) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-5.0f));
        }
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

